package com.agilex.healthcare.mobilehealthplatform.restservice;

import static org.junit.Assert.assertNotNull;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Property;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;

public class NotificationOptStatusResourceTest {

	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void checkWhetherTestsAreRunningInCIHMode() {
		Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev", "dev"));
		client = TestHelper.createMobileHealthClient();
	}
	
	@AfterClass
	public static void destroy() {
		if (client != null) {
			client.getJerseyClient().destroy();
			client = null;
		}
	}

	@Test
	public void verifyNotificationOptStatusProperty() {
		URI uri = generatePropertyUri("notification-option-enabled");
		Property property = client.getJerseyClient().resource(uri).get(Property.class);
		assertNotNull(property);
		assertNotNull(property.getValue());
	}

	private URI generatePropertyUri(String property) {
		return UriBuilder.fromUri(String.format("%s/public/property-directory/%s", IntegrationTestConfiguration.getMobileHealthServerBaseUri(), property)).build();
	}
}
