package com.agilex.healthcare.mobilehealthplatform.restservice;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.agilex.healthcare.utility.XpathHelper;

public class MhpUserResourceTest {

	private static String mhpResourceUri = IntegrationTestConfiguration.getMobileHealthServerBaseUri() + "/mhpuser";
	private Patient testPatient = IntegrationTestConfiguration.getTestPatient();
	
	private static MobileHealthClientTestVersion client;
	
    private static Document mhpUserXml = null;
	
	@BeforeClass
	public static void startUp() {
        if(ModeHelper.isProviderMode()){
            client = TestHelper.createProviderMobileHealthClient();
        }else{
	    	client = TestHelper.createMobileHealthClient();
        }
        mhpUserXml = client.getAsXml(mhpResourceUri);
    }
	
	@AfterClass
	public static void destroy() {
		client.getJerseyClient().destroy();
		client = null;
	}
	
	@Test
	public void validateMhpUserHasCorrectFirstName() {
		Assume.assumeTrue(ModeHelper.isVeteranMode());
		Document mhpUserXml = client.getAsXml(mhpResourceUri);
		String firstName = XpathHelper.getString(mhpUserXml, "/m:mhpUser/firstName");
		assertEquals(testPatient.getFirstName(), firstName.toLowerCase());
	}

	@Test
	public void validateMhpUserHasCorrectLastName() {
		Assume.assumeTrue(ModeHelper.isVeteranMode());
		Document mhpUserXml = client.getAsXml(mhpResourceUri);
		String lastName = XpathHelper.getString(mhpUserXml, "/m:mhpUser/lastName");
		assertEquals(testPatient.getLastName(), lastName.toLowerCase());
	}

	@Test
	public void validateMhpUserHasCorrectId() {
		Assume.assumeTrue(ModeHelper.isVeteranMode());
		Document mhpUserXml = client.getAsXml(mhpResourceUri);
		String id = XpathHelper.getString(mhpUserXml, "/m:mhpUser/id");
		assertEquals(testPatient.getId(), id);
	}

	@Test
	public void validateMhpUserHasPatientAtomLink() {
		Assume.assumeTrue(ModeHelper.isVeteranMode());
		Document mhpUserXml = client.getAsXml(mhpResourceUri);
		Node patientLinkNode = XpathHelper.getNode(mhpUserXml, "//m:mhpUser/atom:link[@title='patient']");
		assertNotNull(patientLinkNode);
	}
	
	@Test
	public void validateMhpUserHasSecureMessageUserLink() {
		Assume.assumeTrue(ModeHelper.isVeteranMode());
		Document mhpUserXml = client.getAsXml(mhpResourceUri);
		Node patientLinkNode = XpathHelper.getNode(mhpUserXml, "//m:mhpUser/atom:link[@title='securemessage-user']");
		assertNotNull(patientLinkNode);
	}
	
	@Test
	public void validateMhpUserHasRightOfAccessLink() {
		Document mhpUserXml = client.getAsXml(mhpResourceUri);
		Node patientLinkNode = XpathHelper.getNode(mhpUserXml, "//m:mhpUser/atom:link[@title='right-of-access']");
		assertNotNull(patientLinkNode);
	}

	@Test
	public void validateMhpUserHasRightOfAccessImageLink() {
		Document mhpUserXml = client.getAsXml(mhpResourceUri);
		Node patientLinkNode = XpathHelper.getNode(mhpUserXml, "//m:mhpUser/atom:link[@title='right-of-access-image']");
		assertNotNull(patientLinkNode);
	}
	
	@Test
	public void validateAppointmentsLink() {
		Assume.assumeTrue(ModeHelper.isVeteranMode());
		Document mhpUserXml = client.getAsXml(mhpResourceUri);
		Node patientLinkNode = XpathHelper.getNode(mhpUserXml, "//m:mhpUser/atom:link[@title='appointments']");
		assertNotNull(patientLinkNode);
	}

	@Test
	public void validatePrimaryCareProvidersLink() {
		Assume.assumeTrue(ModeHelper.isVeteranMode());
		Document mhpUserXml = client.getAsXml(mhpResourceUri);
		Node patientLinkNode = XpathHelper.getNode(mhpUserXml, "//m:mhpUser/atom:link[@title='providers-primarycare']");
		assertNotNull(patientLinkNode);
	}

	@Test
	public void validateMentalHealthProvidersLink() {
		Assume.assumeTrue(ModeHelper.isVeteranMode());
		Document mhpUserXml = client.getAsXml(mhpResourceUri);
		Node patientLinkNode = XpathHelper.getNode(mhpUserXml, "//m:mhpUser/atom:link[@title='providers-mentalhealth']");
		assertNotNull(patientLinkNode);
	}
}