package com.agilex.healthcare.mobilehealthplatform.restservice;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.net.URI;
import java.net.URISyntaxException;

import javax.ws.rs.core.UriBuilder;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.http.HttpStatus;
import org.w3c.dom.Document;

import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.utility.XpathHelper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;

@Ignore
public class HealthCheckStatusTest {
	private static Client jerseyClient;
	
	@BeforeClass
	public static void startUp() {
		jerseyClient = new Client();
	}
	
	@AfterClass
	public static void destroy() {
		jerseyClient.destroy();
		jerseyClient = null;
	}
	
	private URI getHealthUriForHealthyServer() {
		return IntegrationTestConfiguration.getResourceUri("health-check");
	}

	private URI getHealthUriForUnhealthyServer() {
		return UriBuilder.fromUri(getHealthUriForHealthyServer()).queryParam("forcefail", "true").build();
	}

	@Test
	public void isHealthyUsingHead() throws URISyntaxException {
		ClientResponse response = jerseyClient.resource(getHealthUriForHealthyServer()).head();
		assertEquals(HttpStatus.OK, response.getStatus());
	}

	@Test
	public void isUnhealthyUsingHead() throws URISyntaxException {
		ClientResponse response = jerseyClient.resource(getHealthUriForUnhealthyServer()).head();
		assertEquals(HttpStatus.SERVICE_UNAVAILABLE, response.getStatus());
	}

	@Test
	public void isHealthyAsText() throws URISyntaxException {
		String response = jerseyClient.resource(getHealthUriForHealthyServer()).accept("text/plain").get(String.class);
		assertEquals("healthy", response);
	}

	@Test(expected = UniformInterfaceException.class)
	public void isNotHealthyAsTextWithError() throws URISyntaxException {
		Client jerseyClient = new Client();
		jerseyClient.resource(getHealthUriForUnhealthyServer()).accept("application/xml").get(String.class);
	}

	@Test
	public void isHealthyAsXml() throws URISyntaxException {
		Document response = jerseyClient.resource(getHealthUriForHealthyServer()).accept("application/xml").get(Document.class);
		assertEquals("true", XpathHelper.getString(response, "m:healthy/@isHealthy"));
	}

	@Test(expected = UniformInterfaceException.class)
	public void isNotHealthyAsXml() throws URISyntaxException {
		Client jerseyClient = new Client();
		Document response = jerseyClient.resource(getHealthUriForUnhealthyServer()).accept("application/xml").get(Document.class);
		assertEquals("false", XpathHelper.getString(response, "m:healthy/@isHealthy"));
	}

	@Test(expected = UniformInterfaceException.class)
	public void isNotHealthyAsXmlWithErrorEqualTrue() throws URISyntaxException {
		Client jerseyClient = new Client();
		String response = jerseyClient.resource(getHealthUriForUnhealthyServer()).queryParam("e", "true").accept("application/xml").get(String.class);
		assertEquals("unhealthy", response);
	}

	@Test(expected = UniformInterfaceException.class)
	public void isNotHealthyAsXmlWithError() throws URISyntaxException {
		Client jerseyClient = new Client();
		jerseyClient.resource(getHealthUriForUnhealthyServer()).queryParam("e", "").accept("application/xml").get(String.class);
	}

	@Test
	public void isHealthyAsJson() throws URISyntaxException {
		Client jerseyClient = new Client();
		String response = jerseyClient.resource(getHealthUriForHealthyServer()).accept("application/json").get(String.class);
		assertNotNull(response); // not trying to parse it, just looking for
									// lack of error
	}

	@Test(expected = UniformInterfaceException.class)
	public void isUnHealthyAsJson() throws URISyntaxException {
		Client jerseyClient = new Client();
		String response = jerseyClient.resource(getHealthUriForUnhealthyServer()).accept("application/json").get(String.class);
		assertNotNull(response); // not trying to parse it, just looking for
									// lack of error
	}
}
