package com.agilex.healthcare.mobilehealthplatform.restservice;

import static org.junit.Assert.assertNotNull;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.sun.jersey.api.client.Client;


public class ConnectivityTest {
	MobileHealthClientTestVersion mobileHealthClient;

	@Before
	public void setup() {
		mobileHealthClient = TestHelper.createMobileHealthClient();
	}
	
	@After
	public void tearDown() {
		mobileHealthClient.getJerseyClient().destroy();
	}
	
	@Ignore
	//@Test(expected = UniformInterfaceException.class)
	public void serviceHasBeenSecured() {
		String uri = getPatientSearchUri();
		mobileHealthClient.getJerseyClient().resource(uri).get(Document.class);
	}
	
	@Test
	public void canAccessServiceViaJersey() {
		Assume.assumeTrue(ModeHelper.isMode("va-provider-dev"));
		String uri = getPatientSearchUri();

		Client jerseyclient = mobileHealthClient.getJerseyClient();

		Document result = jerseyclient.resource(uri).get(Document.class);
		assertNotNull(result);
	}

	@Test
	public void canAccessServiceViaMhpClient() {
		Assume.assumeTrue(ModeHelper.isMode("va-provider-dev"));
		String uri = getPatientSearchUri();
		Document result = mobileHealthClient.getAsXml(uri);
		assertNotNull(result);
	}

	private String getPatientSearchUri() {
		URI uri = UriBuilder.fromPath(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("patients").queryParam("searchstring", "younger").build();
		return uri.toString();
	}
}
