package com.agilex.healthcare.mobilehealthplatform.restservice;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.net.URI;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import com.agilex.healthcare.mobilehealthplatform.domain.AtomLink;
import com.agilex.healthcare.mobilehealthplatform.domain.AtomLinks;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.ResourceDirectory;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.utility.XpathHelper;
import com.sun.jersey.api.client.Client;

public class AppointmentMetadataTest {
	
	private ResourceDirectory resourceDirectory = null;
	Document metadata = null;
	
	private static Client jerseyClient;
	
	@BeforeClass
	public static void startUp() {
		jerseyClient = new Client();
	}
	
	@AfterClass
	public static void destroy() {
		jerseyClient.destroy();
		jerseyClient = null;
	}
	
	@Before
	public void getResourceAsXml() {
		//Client jerseyClient = new Client();
		resourceDirectory = jerseyClient.resource(getResourceDirectoryURI()).accept("application/xml").get(ResourceDirectory.class);
		URI appointmentsUri = null;
		
		AtomLinks links = resourceDirectory.getLink();
		for (AtomLink atomLink : links) {
			if(atomLink.getTitle().equals(LinkTitles.AppointmentsMetadata)){
				appointmentsUri = atomLink.getHref();
				break;
			}
		}
		
		metadata = jerseyClient.resource(appointmentsUri).accept("application/xml").get(Document.class);
	}
	
	@Test
	public void verifyAppointmentsMetadataAtomLink(){
		AtomLinks links = resourceDirectory.getLink();
		for (AtomLink atomLink : links) {
			if(atomLink.getTitle().equals(LinkTitles.AppointmentsMetadata)){
				assertEquals(IntegrationTestConfiguration.getMobileHealthServerBaseUri()+"/appointment-service/metadata", atomLink.getHref().toString());
				return;
			}
		}
		
		fail("Appointments metadata atom link is not found");
	}
	
	@Test
	public void verifyAppointmentTypes(){
		verifyMetadata("//m:appointments-metadata/appointmentTypes");
	}
	
	@Test
	public void verifyBestTimetoCallOptions(){
		verifyMetadata("//m:appointments-metadata/bestTimetoCallOptions");
	}
	
	@Test
	public void verifyVisitTypes(){
		verifyMetadata("//m:appointments-metadata/visitTypes");
	}

	@Test
	public void verifyPurposeOfVisitOptions(){
		verifyMetadata("//m:appointments-metadata/purposeOfVisitOptions");
	}

	@Test
	public void verifyEarliestTimeVeteranCanRequestAppointmentInDaysIs3Days(){
		String minDaysXPath = "//m:appointments-metadata/earliestTimeVeteranCanRequestAppointmentInDays";
		verifyMetadata(minDaysXPath);
		String actualValue = XpathHelper.getString(metadata, minDaysXPath);
		assertEquals("4", actualValue);
	}

	@Test
	public void verifyFarthestTimeVeteranCanRequestAppointmentInDaysIs120Days(){
		String maxDaysXPath = "//m:appointments-metadata/farthestTimeVeteranCanRequestAppointmentInDays";
		verifyMetadata(maxDaysXPath);
		String actualValue = XpathHelper.getString(metadata, maxDaysXPath);
		assertEquals("120", actualValue);
	}

	@Test
	public void verifyDetailCodes(){
		verifyMetadata("//m:appointments-metadata/detailCodes");
	}
	
	@Test
	public void verifyAppointmentRequestStatusOptions(){
		verifyMetadata("//m:appointments-metadata/appointmentRequestStatusOptions");
	}

	@Test
	public void verifyAppointmentProcessedAsPerUserNeedOption(){
		verifyMetadata("//m:appointments-metadata/appointmentProcessedAsPerUserNeedOptions");
	}

	private void verifyMetadata(String metadataXpath) {
		Node node = XpathHelper.getNode(metadata, metadataXpath);
		assertNotNull(node);
	}
	

	private URI getResourceDirectoryURI() {
		return IntegrationTestConfiguration.getHealthAdapterResourceDirectoryUri();
	}
}
