package com.agilex.healthcare.mobilehealthplatform.clientapi;

import java.io.InputStream;
import java.net.URI;

import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.Documents;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTestGroups;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.mobilehealthplatform.domain.Problems;
import com.agilex.healthcare.utility.NullChecker;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.ClientResponse.Status;
import com.sun.jersey.api.client.WebResource;

public class PatientResourceClient {
	private static org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(PatientResourceClient.class);
	private JerseyClientHandle jerseyClientHandle = null;

	public PatientResourceClient(JerseyClientHandle jerseyClientHandle) {
		log.debug("initializing patient resource client");
		this.jerseyClientHandle = jerseyClientHandle;
	}

	public Patients patientSearch(Patient prototype) {
		Patients patients = null;
		if (prototype != null) {
			com.sun.jersey.api.client.WebResource resourceHandle = jerseyClientHandle.resource().path("patients");
			resourceHandle = addPatientSearchQueryParams(resourceHandle, prototype);
			log.info("get uri " + resourceHandle.getURI().toString());
			patients = resourceHandle.get(Patients.class);
		} else {
			patients = new Patients();
		}

		return patients;
	}

	public Patients patientSearch(String searchString) {
		Patients patients = null;
		if (NullChecker.isNotNullish(searchString)) {
			com.sun.jersey.api.client.WebResource resourceHandle = jerseyClientHandle.resource().path("patients");
			resourceHandle = addPatientSearchQueryParam(resourceHandle, "searchstring", searchString);
			log.info("get uri " + resourceHandle.getURI().toString());
			patients = resourceHandle.get(Patients.class);
		} else {
			patients = new Patients();
		}

		return patients;
	}

	public Patient getPatient(URI uri) {
		com.sun.jersey.api.client.WebResource resourceHandle = jerseyClientHandle.resource(uri);
		log.info("get uri " + resourceHandle.getURI().toString());
		return resourceHandle.get(Patient.class);
	}

	public Patient getPatient(Patient patient) {
		return getPatient(patient.getSelfUri());
	}

	public PatientDemographics getDemographics(URI uri) {
		com.sun.jersey.api.client.WebResource resourceHandle = jerseyClientHandle.resource(uri);
		log.info("get uri " + resourceHandle.getURI().toString());
		return resourceHandle.get(PatientDemographics.class);
	}

	public PatientDemographics getDemographics(Patient patient) {
		return getDemographics(patient.getDemographicsUri());
	}

	private WebResource addPatientSearchQueryParams(WebResource resource, Patient prototype) {
		resource = addPatientSearchQueryParam(resource, "lastname", prototype.getLastName());
		resource = addPatientSearchQueryParam(resource, "firstname", prototype.getFirstName());
		resource = addPatientSearchQueryParam(resource, "patientid", prototype.getId());
		return resource;
	}

	private WebResource addPatientSearchQueryParam(WebResource resource, String queryParamKey, String queryParamValue) {
		if (NullChecker.isNotNullish(queryParamValue)) {
			resource = resource.queryParam(queryParamKey, queryParamValue);
		}
		return resource;
	}

	public InputStream getPatientImage(Patient patient) {
		return getPatientImage(patient.getPatientImageUri());
	}

	public InputStream getPatientImage(URI uri) {
		com.sun.jersey.api.client.WebResource resourceHandle = jerseyClientHandle.resource(uri);
		log.info("get uri " + resourceHandle.getURI().toString());
		ClientResponse response = resourceHandle.get(ClientResponse.class);
		InputStream image = null;
		if (response.getClientResponseStatus() == Status.OK) {
			image = response.getEntityInputStream();
		}
		return image;
	}

	public Problems getPatientActiveProblems(Patient patient) {
		return getPatientActiveProblems(patient.getProblemsUri());
	}

	public Problems getPatientActiveProblems(URI uri) {
		WebResource resourceHandle = jerseyClientHandle.resource(uri);
		log.info("get uri " + resourceHandle.getURI().toString());
		Problems problems = resourceHandle.get(Problems.class);
		return problems;
	}

	public Documents getPatientDocuments(Patient patient) {
		return getPatientDocuments(patient.getDocumentsUri());
	}

	public Documents getPatientDocuments(URI uri) {
		WebResource resourceHandle = jerseyClientHandle.resource(uri);
		log.info("get uri " + resourceHandle.getURI().toString());
		Documents documents = resourceHandle.get(Documents.class);
		return documents;
	}

	public Allergies getPatientAllergies(Patient patient) {
		return getPatientAllergies(patient.getAllergiesUri());
	}

	public Allergies getPatientAllergies(URI uri) {
		WebResource resourceHandle = jerseyClientHandle.resource(uri);
		log.info("get uri " + resourceHandle.getURI().toString());
		Allergies allergies = resourceHandle.get(Allergies.class);
		return allergies;
	}

	public LabTestGroups getPatientLabTestGroups(URI uri) {
		WebResource resourceHandle = jerseyClientHandle.resource(uri);
		log.info("get uri " + resourceHandle.getURI().toString());
		LabTestGroups labTestGroups = resourceHandle.get(LabTestGroups.class);
		return labTestGroups;
	}

	
}
