package com.agilex.healthcare.mobilehealthplatform.clientapi;

import java.net.URI;

import org.w3c.dom.Document;

import com.agilex.healthcare.mobilehealthplatform.client.AuthenticationInfo;
import com.agilex.healthcare.utility.NullChecker;
import com.sun.jersey.api.client.WebResource;

public class MobileHealthClientTestVersion {
	private static org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(MobileHealthClientTestVersion.class);
	private JerseyClientHandle jerseyHandle = null;

	public MobileHealthClientTestVersion(URI uri, AuthenticationInfo authenticationInfo) {
		jerseyHandle = new JerseyClientHandle(uri, authenticationInfo);
	}

	public MobileHealthClientTestVersion(String uri, AuthenticationInfo authenticationInfo) {
		jerseyHandle = new JerseyClientHandle(uri, authenticationInfo);
	}

	public JerseyClientHandle getJerseyClientHandle() {
		return jerseyHandle;
	}

	public com.sun.jersey.api.client.Client getJerseyClient() {
		return getJerseyClientHandle().getJerseyClient();
	}

	public PatientResourceClient getPatientResourceClient() {
		return new PatientResourceClient(this.getJerseyClientHandle());
	}

	public ProblemResourceClient getProblemResourceClient() {
		return new ProblemResourceClient(this.getJerseyClientHandle());
	}

	public AllergyResourceClient getAllergyResourceClient() {
		return new AllergyResourceClient(this.getJerseyClientHandle());
	}

	public Document getAsXml(URI uri) {
		if (NullChecker.isNullish(uri))
			throw new IllegalArgumentException();
		return getAsXml(uri.toString());
	}

	public Document getAsXml(String uri) {
		if (NullChecker.isNullish(uri))
			throw new IllegalArgumentException();
		WebResource resource = jerseyHandle.resource(uri);
		logger.debug("GET " + uri.toString());
		Document result = resource.get(Document.class);
		return result;
	}

}
