package com.agilex.healthcare.mobilehealthplatform.clientapi;

import java.net.URI;
import java.net.URISyntaxException;

import com.agilex.healthcare.mobilehealthplatform.client.AuthenticationInfo;
import com.agilex.healthcare.utility.NullChecker;

public class JerseyClientHandle {
	private URI baseResourceUri = null;
	private AuthenticationInfo authenticationInfo = null;
	private boolean cacheJerseyClient = false;
	private com.sun.jersey.api.client.Client cachedJerseyClient = null;
	private boolean cacheJerseyWebResource = false;
	private com.sun.jersey.api.client.WebResource cachedJerseyWebResource = null;

	public JerseyClientHandle(URI uri, AuthenticationInfo authenticationInfo) {
		if (uri == null) {
			throw new IllegalArgumentException("Invalid URI");
		}
		this.baseResourceUri = uri;
		this.authenticationInfo = authenticationInfo;
	}

	public JerseyClientHandle(String uri, AuthenticationInfo authenticationInfo) {
		if (NullChecker.isNullish(uri)) {
			throw new IllegalArgumentException("Invalid URI");
		}
		URI uriobject = null;
		try {
			uriobject = new URI(uri);
		} catch (URISyntaxException ex) {
			throw new RuntimeException("Unable to parse URI " + uri, ex);
		}
		this.baseResourceUri = uriobject;
		this.authenticationInfo = authenticationInfo;
	}

	public com.sun.jersey.api.client.Client getJerseyClient() {
		com.sun.jersey.api.client.Client jerseyclient = null;

		if (isCacheJerseyClientEnabled()) {
			jerseyclient = cachedJerseyClient;
		}
		if (jerseyclient == null) {
			jerseyclient = JerseyFactory.createJerseyClient(authenticationInfo);
			if (isCacheJerseyClientEnabled()) {
				cachedJerseyClient = jerseyclient;
			}
		}
		return jerseyclient;
	}

	public com.sun.jersey.api.client.WebResource resource() {
		com.sun.jersey.api.client.WebResource jerseyWebResource = null;
		if (isCacheJerseyWebResourceEnabled()) {
			jerseyWebResource = cachedJerseyWebResource;
		}
		if (jerseyWebResource == null) {
			jerseyWebResource = getJerseyClient().resource(this.baseResourceUri);
			if (isCacheJerseyWebResourceEnabled()) {
				cachedJerseyWebResource = jerseyWebResource;
			}
		}
		return jerseyWebResource;
	}

	public com.sun.jersey.api.client.WebResource resource(String uri) {
		URI uriobject = null;
		try {
			uriobject = new URI(uri);
		} catch (URISyntaxException ex) {
			throw new RuntimeException("Unable to parse URI " + uri, ex);
		}
		return resource(uriobject);
	}

	public com.sun.jersey.api.client.WebResource resource(URI uri) {
		com.sun.jersey.api.client.Client client = getJerseyClient();
		return client.resource(uri);
	}

	/**
	 * @return the cacheJerseyClient
	 */
	public boolean isCacheJerseyClientEnabled() {
		return cacheJerseyClient;
	}

	/**
	 * @param enable
	 *            /disable caching of the jersey client
	 */
	public void setCacheJerseyClientEnabled(boolean enabled) {
		this.cacheJerseyClient = enabled;
	}

	/**
	 * @return the cacheJerseyWebResource
	 */
	public boolean isCacheJerseyWebResourceEnabled() {
		return cacheJerseyWebResource;
	}

	/**
	 * @param enabled
	 *            the cacheJerseyWebResource to set
	 */
	public void setCacheJerseyWebResourceEnabled(boolean enabled) {
		this.cacheJerseyWebResource = enabled;
	}

}
