package com.agilex.healthcare.mobilehealthplatform;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.utility.ModeHelper;

import cc.plural.jsonij.parser.ParserException;

public class TestDataCreatorTest {

    @BeforeClass
    public static void isVeteranMode(){
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
    }
    
	@Test
	public void createJSONSample() throws URISyntaxException, IOException, ParserException {

//		 String generateDemoData = System.getProperty("DemoData");
//		 Assume.assumeTrue("true".equals(generateDemoData));

		String baseUri = "http://localhost:8080/MobileHealthPlatformWeb/rest/public/resource-directory/json";
		String testDataDir = "/mhp/testdata";
		String searchUri = "http://localhost:8080/MobileHealthPlatformWeb/rest/patients?searchstring=younger";

		TestDataCreator creator = new TestDataCreator(new URI(baseUri), testDataDir);
		creator.createJSONData(searchUri, true);
	}
	
}
