package com.agilex.healthcare.mobilehealthplatform;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;

import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.testutility.TestHelper;
import com.sun.jersey.api.client.Client;

@Ignore
public class LearnDataCreatorTest {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(TestDataCreatorTest.class);
	private List<String> retrievedUris = new LinkedList<String>();
	private List<String> hrefs = new ArrayList<String>();
	private String[] termsToIgnore = {"condition1"};
	private Client client = TestHelper.createMobileHealthClient().getJerseyClient();
	private String learnDataPath = "/tmp/mhp/learn-data";
	private String baseUri = "http://localhost:8080/MobileHealthPlatformWeb/rest/";
	private File learnDataDirectory;

	@Test
	public void createLearnCategories() throws IOException, URISyntaxException {
		initOutput();
		URI uri = UriBuilder.fromUri(baseUri).path("public/learn/conditions").build();
		createJSONData(uri);
	}

	private void initOutput() {
		learnDataDirectory = new File(learnDataPath);
		if (learnDataDirectory.exists() == false) {
			boolean mkdir = learnDataDirectory.mkdirs();
		}
	}

	private void createJSONData(URI uri) throws IOException, URISyntaxException {
		client.setConnectTimeout(30000);
		client.setReadTimeout(30000);

		if (retrievedUris.contains(uri.toString())) {
			return;
		}
		if(containsTermToIgnore(uri.toString())) {
			logger.debug("ignore this data");
			return;
		}
		retrievedUris.add(uri.toString());
		logger.debug("retrieving from uri " + uri.toString());

		String responseString = client.resource(uri).accept(MediaType.APPLICATION_JSON).get(String.class);
		ObjectMapper mapper = new ObjectMapper();
		JsonNode rootNode = mapper.readTree(responseString);
		findHref(rootNode);
		String jsonString = mapper.writeValueAsString(rootNode);

		for (String hrefValue: hrefs) {
			jsonString = jsonString.replace("\"" + hrefValue + "\"", "\"" + determineFileName(hrefValue) + ".json\"");
		}

		writeToFile(jsonString, determineFileName(uri.toString()) + ".json");
	}

	private boolean containsTermToIgnore(String originalString) {
		for(String termToIgnore : termsToIgnore) {
			if(originalString.contains(termToIgnore)) {
				return true;
			}
		}
		return false;
	}

	private void writeToFile(String dataToWrite, String fileName) throws IOException {
		File f = new File(learnDataPath, fileName);
		logger.debug("writing out to file " + f.getPath());
		FileWriter fstream = new FileWriter(f);
		BufferedWriter out = new BufferedWriter(fstream);
		out.write(dataToWrite);
		out.close();
	}

	private String determineFileName(String uri) {
		String filename = uri.toString();
		uri = remove(uri, "^.*/rest/");
		filename = remove(uri, "^.*/rest");
		filename = filename.replace("http://", "");
		filename = filename.replace("/", "_");
		filename = filename.replace("?", "_");
		filename = filename.replace("=", "_");
		return filename;
	}

	private String remove(String subject, String patternToRemove) {
		Pattern pattern = Pattern.compile(patternToRemove, Pattern.CASE_INSENSITIVE);
		Matcher matcher = pattern.matcher(subject);
		String result = matcher.replaceFirst("");
		return result;
	}

	private void findHref(JsonNode node) throws JsonGenerationException, JsonMappingException, IOException, URISyntaxException {
		if (node != null) {
			JsonParser parser = node.traverse();
			while (parser.nextToken() != null) {
				String value = parser.getText();
				if (value.equalsIgnoreCase("href")) {
					String hrefValue = parser.nextTextValue();
					hrefs.add(hrefValue);
					createJSONData(new URI(hrefValue));
				}
			}
		}
	}
}
