package temp;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.security.AWSCredentials;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.utility.StreamHelper;

@Ignore
public class AmazonS3PrototypeCodeTest {
	// jason's private key
	private String awsAccessKey = "?";
	private String awsSecretKey = "?";

	@Test
	public void howManyBuckets() throws S3ServiceException {
		AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey);
		S3Service s3Service = new RestS3Service(awsCredentials);
		S3Bucket[] myBuckets = s3Service.listAllBuckets();
		System.out.println("*** How many buckets to I have in S3? " + myBuckets.length);
	}

	@Test
	public void infoOnBucket() throws S3ServiceException {
		AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey);
		S3Service s3Service = new RestS3Service(awsCredentials);
		S3Bucket[] myBuckets = s3Service.listAllBuckets();
		for (S3Bucket bucket : myBuckets) {
			System.out.println("*** bucket name:" + bucket.getName());
		}
	}

	@Test
	public void stuffInBucket() throws S3ServiceException {
		String xdsBucketName = "xds-repo";
		AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey);
		S3Service s3Service = new RestS3Service(awsCredentials);
		S3Object[] stuffInBucket = s3Service.listObjects(xdsBucketName);
		for (S3Object item : stuffInBucket) {
			System.out.println("*** found item " + item.getName());
		}
	}

	@Test
	public void findParticularFolderThatDoesntExist() throws S3ServiceException {
		String xdsBucketName = "xds-repo";
		String folderThatDoesntExist = "unknown/";
		AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey);
		S3Service s3Service = new RestS3Service(awsCredentials);
		System.out.println("*** retrieve for folder " + folderThatDoesntExist);
		S3Object[] stuffInBucket = s3Service.listObjects(xdsBucketName, folderThatDoesntExist, null);
		for (S3Object item : stuffInBucket) {
			System.out.println("*** found item (prefix=" + folderThatDoesntExist + ") " + item.getName());
		}
	}

	@Test
	public void findParticularFolder() throws S3ServiceException {
		String xdsBucketName = "xds-repo";
		String folder = "MRN-123/";
		AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey);
		S3Service s3Service = new RestS3Service(awsCredentials);
		S3Object[] stuffInBucket = s3Service.listObjects(xdsBucketName, folder, null);
		for (S3Object item : stuffInBucket) {
			System.out.println("*** found item (prefix=" + folder + ") " + item.getName());
		}
	}

	@Test
	public void metadataForItems() throws S3ServiceException {
		String xdsBucketName = "xds-repo";
		String folder = "MRN-123/";
		AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey);
		S3Service s3Service = new RestS3Service(awsCredentials);
		S3Object[] stuffInBucket = s3Service.listObjects(xdsBucketName, folder, null);
		for (S3Object item : stuffInBucket) {
			System.out.println("*** found item (prefix=" + folder + ") " + item.getName() + ";key=" + item.getKey() + "; title=" + item.getMetadata("x-amz-meta-document-title"));
			for (String metadataKeys : item.getMetadataMap().keySet()) {
				System.out.println("found key:" + metadataKeys + "; value=" + item.getMetadata(metadataKeys));
			}
			for (String metadataKeys : item.getModifiableMetadata().keySet()) {
				System.out.println("found m-key:" + metadataKeys + "; value=" + item.getMetadata(metadataKeys));
			}
		}
	}

	@Test
	public void metadataForItem() throws ServiceException {
		String xdsBucketName = "xds-repo";
		String itemName = "MRN-123/hello-world.txt";
		AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey);
		S3Service s3Service = new RestS3Service(awsCredentials);
		StorageObject item = s3Service.getObjectDetails(xdsBucketName, itemName);
		System.out.println("*** found item " + item.getName() + ";key=" + item.getKey() + "; title=" + item.getMetadata("document-title"));
		for (String metadataKeys : item.getMetadataMap().keySet()) {
			System.out.println("found key:" + metadataKeys + "; value=" + item.getMetadata(metadataKeys));
		}
		for (String metadataKeys : item.getModifiableMetadata().keySet()) {
			System.out.println("found m-key:" + metadataKeys + "; value=" + item.getMetadata(metadataKeys));
		}
	}

	@Test
	public void listDetailsForItemsByPatient() throws ServiceException {
		String xdsBucketName = "xds-repo";
		String patient = "MRN-123/";
		AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey);
		S3Service s3Service = new RestS3Service(awsCredentials);

		S3Object[] documents = s3Service.listObjects(xdsBucketName, patient, null);
		System.out.println("retrieved " + documents.length + " item(s)");
		for (S3Object document : documents) {
			if (!document.getName().contentEquals(patient)) {
				StorageObject documentMetadata = s3Service.getObjectDetails(xdsBucketName, document.getName());
				StringBuffer metadataData = new StringBuffer();
				for (String metadataKeys : documentMetadata.getModifiableMetadata().keySet()) {
					metadataData.append(String.format("[%s='%s']", metadataKeys, documentMetadata.getMetadata(metadataKeys)));
				}
				System.out.println(String.format("*** document [name=%s];[key=%s][title=%s];m:%s", document.getName(), document.getKey(), documentMetadata.getMetadata("document-title"),
						metadataData.toString()));
			}
		}
	}

	@Test
	public void getTextData() throws ServiceException, IOException, NoSuchAlgorithmException {
		String xdsBucketName = "xds-repo";
		String filename = "MRN-123/hello-world.txt";
		AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey);
		S3Service s3Service = new RestS3Service(awsCredentials);
		S3Object document = s3Service.getObject(xdsBucketName, filename);
		String text = StreamHelper.streamToString(document.getDataInputStream());
		boolean valid = document.verifyData(text.getBytes("UTF-8"));
		System.out.println(String.format("data:[%s] valid:%s", text, Boolean.toString(valid)));
	}
}
