package com.agilex.healthcare.mobilehealthplatform.datalayer.AmazonS3;

import static org.junit.Assert.*;

import java.io.InputStream;

import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.document.DocumentDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.document.DocumentQueryParameters;
import com.agilex.healthcare.mobilehealthplatform.domain.nhin.Document;
import com.agilex.healthcare.mobilehealthplatform.domain.nhin.DocumentBody;
import com.agilex.healthcare.mobilehealthplatform.domain.nhin.Documents;
import com.agilex.healthcare.mobilehealthplatform.domain.nhin.QualifiedPatientIdentifier;
import com.agilex.healthcare.utility.StreamHelper;

@Ignore
public class DocumentRepoTest {
	private static String newline = System.getProperty("line.separator");

	@Test
	public void getDocumentList() {
		DocumentDataLayer dao = new AmazonS3DataLayer();
		DocumentQueryParameters params = new DocumentQueryParameters();
		QualifiedPatientIdentifier patient = new QualifiedPatientIdentifier();
		patient.setPatientId("MRN-123");
		params.setPatient(patient);
		Documents documents = dao.DocumentSearch(params);
		assertEquals(2, documents.size());
		for (Document d : documents) {
			System.out.println(String.format("title:%s;id's[%s;%s;%s]", d.getDocumentTitle(), d.getHomeCommunityId(), d.getRepositoryId(), d.getDocumentUniqueId()));
		}
	}

	@Test
	public void getDocumentBody() {
		DocumentDataLayer dao = new AmazonS3DataLayer();
		DocumentBody body = dao.RetrieveDocumentBody(null, "xds-repo", "hello-world.txt");
		InputStream contentStream = body.getBody();
		String content = StreamHelper.streamToString(contentStream);
		content = content.replace(newline, "");
		assertEquals("hello world", content);
	}
}
