package com.agilex.healthcare.mobilehealthplatform.datalayer.AmazonS3;


import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.security.AWSCredentials;

import com.agilex.healthcare.mobilehealthplatform.datalayer.document.DocumentDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.document.DocumentQueryParameters;
import com.agilex.healthcare.mobilehealthplatform.domain.nhin.Document;
import com.agilex.healthcare.mobilehealthplatform.domain.nhin.DocumentBody;
import com.agilex.healthcare.mobilehealthplatform.domain.nhin.Documents;
import com.agilex.healthcare.mobilehealthplatform.domain.nhin.QualifiedPatientIdentifier;
import com.agilex.healthcare.utility.NullChecker;

public class AmazonS3DataLayer implements DocumentDataLayer {
	private static final String S3_COMMUNITY_ID = "s3";

	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(AmazonS3DataLayer.class);

	// jason's private key, move this to property file
	// + get shared one for agilex
	private String awsAccessKey = "?";
	private String awsSecretKey = "?";
	private String xdsBucketName = "xds-repo";

	// private static final org.apache.commons.logging.Log logger =
	// org.apache.commons.logging.LogFactory.getLog(AmazonS3DataLayer.class);

	@Override
	public Document RetrieveDocumentMetadata(String homeCommunityId, String registryId, String documentUniqueId) {
		// logger.debug("document search request");
		// assertIsValidSearchParams(params);
		//
		// String patientFolder = buildS3FolderName(params.getPatient());
		// S3Service s3Service = getS3Service();
		// S3Object[] objectsInPatientFolder =
		// getChildObjectsInFolder(s3Service, patientFolder);
		//
		// Documents documentList = new Documents();
		// for (S3Object s3o : objectsInPatientFolder) {
		// if (!isObjectTheFolder(s3o, patientFolder)) {
		// logger.debug(String.format("processing object [%s]", s3o.getName()));
		// Document d = createDocumentFromS3Object(s3Service, s3o,
		// params.getPatient());
		// documentList.add(d);
		// }
		//
		// }
		// return documentList;

		S3Service s3Service = getS3Service();
		StorageObject s3o = getObjectDetails(s3Service, registryId, documentUniqueId);
		Document d = createDocumentFromS3Object(s3Service, s3o);
		return d;

	}

	@Override
	public DocumentBody RetrieveDocumentBody(String homeCommunityId, String registryId, String documentUniqueId) {
		S3Service s3Service = getS3Service();
		S3Object s3o = getS3Object(s3Service, registryId, documentUniqueId);
		DocumentBody docBody = buildDocumentBodyFromS3Object(s3o);
		return docBody;
	}

	@Override
	public Documents DocumentSearch(DocumentQueryParameters params) {
		logger.debug("document search request");
		assertIsValidSearchParams(params);

		String patientFolder = buildS3FolderName(params.getPatient());
		S3Service s3Service = getS3Service();
		S3Object[] objectsInPatientFolder = getChildObjectsInFolder(s3Service, patientFolder);

		Documents documentList = new Documents();
		for (StorageObject s3o : objectsInPatientFolder) {
			if (!isObjectTheFolder(s3o, patientFolder)) {
				logger.debug(String.format("processing object [%s]", s3o.getName()));
				Document d = createDocumentFromS3Object(s3Service, s3o);
				documentList.add(d);
			}

		}
		return documentList;
	}

	private DocumentBody buildDocumentBodyFromS3Object(S3Object s3o) {
		DocumentBody docBody = new DocumentBody();
		try {
			docBody.setBody(s3o.getDataInputStream());
		} catch (ServiceException e) {
			throw new RuntimeException("Error access input stream from s3o", e);
		}
		docBody.setMimeType(s3o.getContentType());
		return docBody;
	}

	private S3Object getS3Object(S3Service s3Service, String registryId, String documentUniqueId) {
		S3Object s3o;
		try {
			s3o = s3Service.getObject(registryId, decodeDocumentId(documentUniqueId));
		} catch (S3ServiceException e) {
			throw new RuntimeException(String.format("Unable to retrieve document body.  [%s;%s]", registryId, documentUniqueId), e);
		}
		return s3o;
	}

	private void assertIsValidSearchParams(DocumentQueryParameters params) {
		if (params == null)
			throw new IllegalArgumentException();
		if (params.getPatient() == null)
			throw new IllegalArgumentException();
		if (NullChecker.isNullish(params.getPatient().getPatientId()))
			throw new IllegalArgumentException();
	}

	private boolean isObjectTheFolder(StorageObject s3object, String patientFolderName) {
		return patientFolderName.contentEquals(s3object.getName());
	}

	private Document createDocumentFromS3Object(S3Service s3Service, StorageObject s3Object) {
		Document d = new Document();
		d.setHomeCommunityId(S3_COMMUNITY_ID);
		d.setRepositoryId(xdsBucketName);
		d.setDocumentUniqueId(encodeDocumentId(s3Object.getName()));
		// QualifiedPatientIdentifier p = patientIdentifier;
		// d.setPatientIdentifier(p);
		StorageObject documentDetails = getObjectDetails(s3Service, d);
		String documentTitle = documentDetails.getMetadata("document-title").toString();
		d.setDocumentTitle(documentTitle);
		logger.debug(String.format("document title [%s]", d.getDocumentTitle()));
		return d;
	}

	private StorageObject getObjectDetails(S3Service s3service, Document d) {
		// String homeCommnityId = d.getHomeCommunityId();
		String repositoryId = d.getRepositoryId();
		String documentUniqueId = d.getDocumentUniqueId();
		return getObjectDetails(s3service, repositoryId, documentUniqueId);
	}

	private StorageObject getObjectDetails(S3Service s3service, String repositoryId, String documentUniqueId) {
		StorageObject documentDetails = null;
		try {
			documentDetails = s3service.getObjectDetails(repositoryId, decodeDocumentId(documentUniqueId));
		} catch (ServiceException e) {
			throw new RuntimeException(String.format("Failed to retrieve details for object [bucket=%s][object=%s]", repositoryId, documentUniqueId), e);
		}
		return documentDetails;
	}

	private S3Object[] getChildObjectsInFolder(S3Service s3Service, String patientFolder) {
		S3Object[] objectsInPatientFolder;
		try {
			objectsInPatientFolder = s3Service.listObjects(xdsBucketName, patientFolder, null);
		} catch (S3ServiceException e) {
			throw new RuntimeException(String.format("Unable to retrieve list of objects from s3 service.  [b=%s][p=%s]", xdsBucketName, patientFolder), e);
		}
		return objectsInPatientFolder;
	}

	private String buildS3FolderName(QualifiedPatientIdentifier patientIdentifier) {
		String patientFolder = patientIdentifier.getPatientId() + "/";
		return patientFolder;
	}

	private String encodeDocumentId(String filename) {
		return filename.replace("/", "~");
	}

	private String decodeDocumentId(String filename) {
		return filename.replace("~", "/");
	}

	private S3Service getS3Service() {
		AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey);
		S3Service s3Service;
		try {
			s3Service = new RestS3Service(awsCredentials);
		} catch (S3ServiceException e) {
			throw new RuntimeException("Failed to connect to Amazon S3 services", e);
		}
		return s3Service;
	}

}
