package com.agilex.healthcare.mobilehealthplatform.ovid.util;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.DOBDate;

public class OvidDateHelperTest {

	@Test
	public void createDOBDateFrom10_30_2010() {
		DOBDate dobDate = OvidDateHelper.createDOBDate("10/30/2010");
		assertEquals("Oct 30, 2010", dobDate.toString());
	}

	@Test
	public void createDOBDateFrom10_0_2010() {
		DOBDate dobDate = OvidDateHelper.createDOBDate("10/0/2010");
		assertEquals("Oct 2010", dobDate.toString());
	}

	@Test
	public void createDOBDateFrom0_0_2010() {
		DOBDate dobDate = OvidDateHelper.createDOBDate("0/0/2010");
		assertEquals("2010", dobDate.toString());
	}

	@Test
	public void validateExceptionIsThrownWithInvalidInputMonth() {
		assertNull(OvidDateHelper.createDOBDate("13/0/2010"));
	}

	@Test
	public void validateExceptionIsThrownWithInvalidInputDay() {
		assertNull(OvidDateHelper.createDOBDate("12/33/2010"));
	}

	@Test
	public void handleSensitivePatient() {
		assertNull(OvidDateHelper.createDOBDate("*SENSITIVE*"));
	}

	@Test
	public void handleSensitivePatientWithLowerCase() {
		assertNull(OvidDateHelper.createDOBDate("*sensitive*"));
	}

}
