package com.agilex.healthcare.mobilehealthplatform.ovid.util;

import static org.junit.Assert.assertEquals;

import java.util.Date;

import org.junit.Test;

import com.agilex.healthcare.utility.DateHelper;

public class OvidDateHelperConvertToJavaDateTest {

	@Test
	public void fromDate() {
		Date dt = OvidDateHelper.transformToJavaDate("10/11/2009");
		assertEquals(DateHelper.parse("11-OCT-2009", "dd-MMM-yyyy"), dt);
	}

	@Test
	public void fromDateTime() {
		Date dt = OvidDateHelper.transformToJavaDate("10/11/2009 12:34");
		assertEquals(DateHelper.parse("11-OCT-2009 12:34", "dd-MMM-yyyy hh:mm"), dt);
	}

}
