package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.lab;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;

public class ReferenceRangeFormatterTest {
	@Test
	public void formatWithNormalReferenceRange() {
		runReferenceRangeFormattingTest("1-2", "1", "2");
	}

	@Test
	public void formatWithBlankLower() {
		runReferenceRangeFormattingTest("-2", null, "2");
	}

	@Test
	public void formatWithBlankUpper() {
		runReferenceRangeFormattingTest("1-", "1", null);
	}

	@Test
	public void formatWithLowerBoundNoDash() {
		runReferenceRangeFormattingTest(">1", "1", null);
	}

	@Test
	public void formatWithLowerBoundWithSpaces() {
		runReferenceRangeFormattingTest(" >1 ", "1", null);
	}

	@Test
	public void formatGtEndingWithDash() {
		runReferenceRangeFormattingTest(">1-", "1", null);
	}

	@Test
	public void formatLtEndingWithDash() {
		runReferenceRangeFormattingTest("<1-", null, "1");
	}

	@Test
	public void formatGtStartingWithDash() {
		runReferenceRangeFormattingTest("->1", "1", null);
	}

	@Test
	public void formatLtStartingWithDash() {
		runReferenceRangeFormattingTest("-<1", null, "1");
	}

	@Test
	public void formatLtStartingWithDashAndSpaces() {
		runReferenceRangeFormattingTest(" - <1 ", null, "1");
	}

	@Test
	public void formatWithUpperBoundNoDash() {
		runReferenceRangeFormattingTest("<1", null, "1");
	}

	@Test
	public void formatWithUpperBoundWithSpaces() {
		runReferenceRangeFormattingTest(" <1 ", null, "1");
	}

	@Test
	public void formatStartingWithDot() {
		runReferenceRangeFormattingTest(".5-", ".5", null);
	}

	@Test
	public void formatStartingWithDotInHigh() {
		runReferenceRangeFormattingTest("-.5", null, ".5");
	}

	@Test
	public void formatWithDot() {
		runReferenceRangeFormattingTest("1.5-2.5", "1.5", "2.5");
	}

	@Test
	public void formatNull() {
		runReferenceRangeFormattingTest(null, null, null);
	}

	@Test
	public void formatBlank() {
		runReferenceRangeFormattingTest("", null, null);
	}

	@Test
	public void formatWithExtraSpaces() {
		runReferenceRangeFormattingTest("60 - 123", "60", "123");
	}

	private void runReferenceRangeFormattingTest(String referenceRange, String expectedLow, String expectedHigh) {
		ReferenceRangeFormatter formatter = new ReferenceRangeFormatter();
		LabResult labResult = new LabResult();
		formatter.fillReferenceRange(referenceRange, labResult);
		assertEquals("Failed low test on reference range '" + referenceRange + "'", expectedLow, labResult.getReferenceLow());
		assertEquals("Failed high test on reference range '" + referenceRange + "'", expectedHigh, labResult.getReferenceHigh());
	}

}
