package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.ovid.domain.OvidMedication;
import com.agilex.healthcare.utility.DateHelper;


public class MedicationActiveCalculatorTest {
	
	@Test
	public void validateMedicationIsActiveWhenMedicationStatusIsActive(){
		MedicationActiveCalculator medActiveCalculator = new MedicationActiveCalculator();
		OvidMedication ovidMedication = new OvidMedication();
		ovidMedication.setStatus(MedicationActiveCalculator.STATUS_ACTIVE);
		assertTrue(medActiveCalculator.determineIsActive(ovidMedication));
	}

	@Test
	public void validateMedicationIsActiveWhenMedicationStatusIsActiveSuspended(){
		MedicationActiveCalculator medActiveCalculator = new MedicationActiveCalculator();
		OvidMedication ovidMedication = new OvidMedication();
		ovidMedication.setStatus(MedicationActiveCalculator.STATUS_ACTIVESUSPENDED);
		assertTrue(medActiveCalculator.determineIsActive(ovidMedication));
	}
	
	@Test
	public void validateMedicationIsActiveWhenMedicationStatusIsExpiredAndButLE120Days(){
		MedicationActiveCalculator medActiveCalculator = new MedicationActiveCalculator(DateHelper.parseDate("6/1/2011"));
		OvidMedication ovidMedication = new OvidMedication();
		ovidMedication.setStatus(MedicationActiveCalculator.STATUS_EXPIRED);
		ovidMedication.setStopDate(DateHelper.parseDate("2/1/2011"));
		assertTrue(medActiveCalculator.determineIsActive(ovidMedication));
	}

	@Test
	public void validateMedicationIsActiveWhenMedicationStatusIsExpiredAndButLE119Days(){
		MedicationActiveCalculator medActiveCalculator = new MedicationActiveCalculator(DateHelper.parseDate("6/1/2011"));
		OvidMedication ovidMedication = new OvidMedication();
		ovidMedication.setStatus(MedicationActiveCalculator.STATUS_EXPIRED);
		ovidMedication.setStopDate(DateHelper.parseDate("2/2/2011"));
		assertTrue(medActiveCalculator.determineIsActive(ovidMedication));
	}

	@Test
	public void validateMedicationIsInactiveWhenMedicationStatusIsExpiredAndButLE121Days(){
		MedicationActiveCalculator medActiveCalculator = new MedicationActiveCalculator(DateHelper.parseDate("6/1/2011"));
		OvidMedication ovidMedication = new OvidMedication();
		ovidMedication.setStatus(MedicationActiveCalculator.STATUS_EXPIRED);
		ovidMedication.setStopDate(DateHelper.parseDate("1/31/2011"));
		assertFalse(medActiveCalculator.determineIsActive(ovidMedication));
	}
	
	@Test
	public void validateMedicationIsInActiveWhenMedicationStatusIsExpiredAndStopDateisNull(){
		MedicationActiveCalculator medActiveCalculator = new MedicationActiveCalculator(DateHelper.parseDate("6/1/2011"));
		OvidMedication ovidMedication = new OvidMedication();
		ovidMedication.setStatus(MedicationActiveCalculator.STATUS_EXPIRED);
		ovidMedication.setStopDate(null);
		assertFalse(medActiveCalculator.determineIsActive(ovidMedication));
	}
	
	@Test
	public void validateMedicationIsInActiveWhenMedicationStatusOtherthanActive_ActSuspended_ExpiredLE120(){
		MedicationActiveCalculator medActiveCalculator = new MedicationActiveCalculator(DateHelper.parseDate("6/1/2011"));
		OvidMedication ovidMedication = new OvidMedication();
		ovidMedication.setStatus(null);
		assertFalse(medActiveCalculator.determineIsActive(ovidMedication));
	}

}
