package com.agilex.healthcare.mobilehealthplatform.ovid.fmdomain;

import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

import com.medsphere.fileman.FMAnnotateFieldInfo;
import com.medsphere.fileman.FMField;
import com.medsphere.fileman.FMFile;
import com.medsphere.fileman.FMRecord;
import com.medsphere.fileman.FMResultSet;

public class FMTopographyField extends FMRecord {
	/*-------------------------------------------------------------
	 * begin static initialization
	 *-------------------------------------------------------------*/
	private static Set<FMField> domainFields;
	private static FMFile fileInfo;
	private static Map<String, AnnotatedElement> domainJavaFields;
	private static Map<String, String> domainNumbers;

	static {
		domainJavaFields = getDomainJavaFields(FMTopographyField.class);
		domainFields = getFieldsInDomain(domainJavaFields);
		domainNumbers = getNumericMapping(FMTopographyField.class);
		fileInfo = new FMFile("61") {
			@Override
			public Collection<FMField> getFields() {
				return domainFields;
			}
		};
		fileInfo.setPack(true);

	}

	public static FMFile getFileInfoForClass() {
		return fileInfo;
	}

	@Override
	protected Set<FMField> getDomainFields() {
		return domainFields;
	}

	@Override
	protected Map<String, AnnotatedElement> getDomainJavaFields() {
		return domainJavaFields;
	}

	@Override
	protected Map<String, String> getNumericMapping() {
		return domainNumbers;
	}

	/*-------------------------------------------------------------
	 * end static initialization
	 *-------------------------------------------------------------*/

	@FMAnnotateFieldInfo(name = "NAME", number = ".01", fieldType = FMField.FIELDTYPE.FREE_TEXT)
	protected String name;

	@FMAnnotateFieldInfo(name = "ABBREVIATION", number = "6", fieldType = FMField.FIELDTYPE.FREE_TEXT)
	protected String abbreviation;	
    
    public FMTopographyField() {
        super(fileInfo.getFileName());
    }
    
	public FMTopographyField(FMResultSet results) {
		super(fileInfo.getFileName());
		//super(results);
		processResults(results);
	}

	public String getName() {
		return name;
	}

	public String getAbbreviation() {
		return abbreviation;
	}
    
    @Override
    public String toString() {
    	return "[FMTopographyField] IEN=" + getIEN()
        	+ ((getName() != null) ? " name=["+ getName() +"]" : "")
        	+ " abbreviation=[" + getAbbreviation() + "]"
       ;
    }	

}
