package com.agilex.healthcare.mobilehealthplatform.ovid.fmdomain;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

import com.medsphere.fileman.FMAnnotateFieldInfo;
import com.medsphere.fileman.FMField;
import com.medsphere.fileman.FMFile;
import com.medsphere.fileman.FMRecord;
import com.medsphere.fileman.FMResultSet;

public class FMLabReportTestGroup extends FMRecord {
	/*-------------------------------------------------------------
	 * begin static initialization
	 *-------------------------------------------------------------*/
	private static Set<FMField> domainFields;
	private static FMFile fileInfo;
	private static Map<String, AnnotatedElement> domainJavaFields;
	private static Map<String, String> domainNumbers;

	static {
		domainJavaFields = getDomainJavaFields(FMLabReportTestGroup.class);
		domainFields = getFieldsInDomain(domainJavaFields);
		domainNumbers = getNumericMapping(FMLabReportTestGroup.class);
		fileInfo = new FMFile("10") {
			@Override
			public Collection<FMField> getFields() {
				return domainFields;
			}
		};
		fileInfo.setPack(true);

	}

	public static FMFile getFileInfoForClass() {
		return fileInfo;
	}

	@Override
	protected Set<FMField> getDomainFields() {
		return domainFields;
	}

	@Override
	protected Map<String, AnnotatedElement> getDomainJavaFields() {
		return domainJavaFields;
	}

	@Override
	protected Map<String, String> getNumericMapping() {
		return domainNumbers;
	}

	/*-------------------------------------------------------------
	 * end static initialization
	 *-------------------------------------------------------------*/

    @FMAnnotateFieldInfo( name="MINOR HEADER", number=".01", fieldType=FMField.FIELDTYPE.FREE_TEXT)
    protected String minorHeader;
    
    @FMAnnotateFieldInfo(name = "TYPE OF DISPLAY", number = "2", fieldType = FMField.FIELDTYPE.SET_OF_CODES)
    protected String typeOfDisplay;
    
    @FMAnnotateFieldInfo( name="LAB TEST", number="10", fieldType=FMField.FIELDTYPE.SUBFILE)
    protected FMLabReportLabTest labTest;    
    
    protected Collection<FMLabReportLabTest> labTests = null;  
    
    public FMLabReportTestGroup() {
    	super(fileInfo.getFileName());
    }

    public FMLabReportTestGroup(FMResultSet results) {
    	super(fileInfo.getFileName());
        processResults(results);
    }

    public String getMinorHeader() {
        return minorHeader;
    }
    
	public String getTypeOfDisplay() {
		return typeOfDisplay;
	}  
    
	public FMLabReportLabTest getLabTest() {
        if (labTest == null) {
        	labTest = new FMLabReportLabTest();
        	labTest.setParent( this );
        }
        return labTest;
    }

    public void addLabTest(FMLabReportLabTest labTest) {
        if (labTests == null) {
        	labTests = new ArrayList<FMLabReportLabTest>();
        }
        labTests.add(labTest);
    }

    public Collection<FMLabReportLabTest> getLabTests() {
        return labTests;
    }
    
    @Override
    public String toString() {
    	return "[FMLabReportTestGroup] IEN=" + getIEN()
    	+ " minorHeader=[" + minorHeader + "]"
    	+ " typeOfDisplay=[" + typeOfDisplay + "]"
    	+ ((labTests != null) ? " LAB TEST subfile=["+ getLabTests() +"]" : "")
    	;
    }	    
}
