package com.agilex.healthcare.mobilehealthplatform.ovid.fmdomain;

import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

import com.medsphere.fileman.FMAnnotateFieldInfo;
import com.medsphere.fileman.FMField;
import com.medsphere.fileman.FMFile;
import com.medsphere.fileman.FMRecord;
import com.medsphere.fileman.FMResultSet;

public class FMLabReportLabTest extends FMRecord {
	/*-------------------------------------------------------------
	 * begin static initialization
	 *-------------------------------------------------------------*/
	private static Set<FMField> domainFields;
	private static FMFile fileInfo;
	private static Map<String, AnnotatedElement> domainJavaFields;
	private static Map<String, String> domainNumbers;

	static {
		domainJavaFields = getDomainJavaFields(FMLabReportLabTest.class);
		domainFields = getFieldsInDomain(domainJavaFields);
		domainNumbers = getNumericMapping(FMLabReportLabTest.class);
		fileInfo = new FMFile("10") {
			@Override
			public Collection<FMField> getFields() {
				return domainFields;
			}
		};
		fileInfo.setPack(true);

	}

	public static FMFile getFileInfoForClass() {
		return fileInfo;
	}

	@Override
	protected Set<FMField> getDomainFields() {
		return domainFields;
	}

	@Override
	protected Map<String, AnnotatedElement> getDomainJavaFields() {
		return domainJavaFields;
	}

	@Override
	protected Map<String, String> getNumericMapping() {
		return domainNumbers;
	}

	/*-------------------------------------------------------------
	 * end static initialization
	 *-------------------------------------------------------------*/

    @FMAnnotateFieldInfo( name="LAB TEST", number=".01", fieldType=FMField.FIELDTYPE.POINTER_TO_FILE)
    protected Integer labTest;
    
    @FMAnnotateFieldInfo(name = "PRINT TEST NAME", number = "2", fieldType = FMField.FIELDTYPE.FREE_TEXT)
    protected String printTestName;
       
    public FMLabReportLabTest() {
    	super(fileInfo.getFileName());
    }

    public FMLabReportLabTest(FMResultSet results) {
    	super(fileInfo.getFileName());
        processResults(results);
    }    
 
    public Integer getLabTest() {
        return labTest;
    }
    
    public String getPrintTestName() {
		return printTestName;
	}

	@Override
    public String toString() {
    	return "[FMLabReportLabTest] IEN=" + getIEN()
    	+ " labTest=[" + labTest + "]"
    	+ " printTestName=[" + printTestName + "]"
    	;
    }    
}
