package com.agilex.healthcare.mobilehealthplatform.ovid.fmdomain;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

import com.medsphere.fileman.FMAnnotateFieldInfo;
import com.medsphere.fileman.FMField;
import com.medsphere.fileman.FMFile;
import com.medsphere.fileman.FMRecord;
import com.medsphere.fileman.FMResultSet;

public class FMLabReportHeader extends FMRecord {
	/*-------------------------------------------------------------
	 * begin static initialization
	 *-------------------------------------------------------------*/
	private static Set<FMField> domainFields;
	private static FMFile fileInfo;
	private static Map<String, AnnotatedElement> domainJavaFields;
	private static Map<String, String> domainNumbers;

	static {
		domainJavaFields = getDomainJavaFields(FMLabReportHeader.class);
		domainFields = getFieldsInDomain(domainJavaFields);
		domainNumbers = getNumericMapping(FMLabReportHeader.class);
		fileInfo = new FMFile("10") {
			@Override
			public Collection<FMField> getFields() {
				return domainFields;
			}
		};
		fileInfo.setPack(true);

	}

	public static FMFile getFileInfoForClass() {
		return fileInfo;
	}

	@Override
	protected Set<FMField> getDomainFields() {
		return domainFields;
	}

	@Override
	protected Map<String, AnnotatedElement> getDomainJavaFields() {
		return domainJavaFields;
	}

	@Override
	protected Map<String, String> getNumericMapping() {
		return domainNumbers;
	}

	/*-------------------------------------------------------------
	 * end static initialization
	 *-------------------------------------------------------------*/

    @FMAnnotateFieldInfo( name="MAJOR HEADER", number=".01", fieldType=FMField.FIELDTYPE.FREE_TEXT)
    protected String majorHeader;

    @FMAnnotateFieldInfo( name="MEDICAL CENTER", number="5", fieldType=FMField.FIELDTYPE.FREE_TEXT)
    protected String medicalCenter;

    @FMAnnotateFieldInfo( name="MINOR HEADER", number="10", fieldType=FMField.FIELDTYPE.SUBFILE)
    protected FMLabReportTestGroup minorHeader;
    
    protected Collection<FMLabReportTestGroup> minorHeaders = null;  
    
    public FMLabReportHeader() {
    	super(fileInfo.getFileName());
    }

    public FMLabReportHeader(FMResultSet results) {
    	super(fileInfo.getFileName());
        processResults(results);
    }
	
    public String getMajorHeader() {
        return majorHeader;
    }
    
    public String getMedicalCenter() {
		return medicalCenter;
	}

	public FMLabReportTestGroup getMinorHeader() {
        if (minorHeader == null) {
        	minorHeader = new FMLabReportTestGroup();
        	minorHeader.setParent( this );
        }
        return minorHeader;
    }

    public void addMinorHeader(FMLabReportTestGroup minorHeader) {
        if (minorHeaders == null) {
        	minorHeaders = new ArrayList<FMLabReportTestGroup>();
        }
        minorHeaders.add(minorHeader);
    }

    public void setMinorHeaders(Collection<FMLabReportTestGroup> minorHeaders) {
        if (this.minorHeaders == null) {
        	this.minorHeaders = new ArrayList<FMLabReportTestGroup>();
        }
        else {
        	this.minorHeaders.clear();
        }
        
        if (minorHeaders != null && !minorHeaders.isEmpty()) {
        	this.minorHeaders.addAll(minorHeaders);
        }
    }
    
    public Collection<FMLabReportTestGroup> getMinorHeaders() {
        return minorHeaders;
    }
    
    @Override
    public String toString() {
    	return "[FMLabReportHeader] IEN=" + getIEN()
    	+ " majorHeader=[" + majorHeader + "]"
    	+ " medicalCenter=[" + medicalCenter + "]"
    	+ ((minorHeaders != null) ? " MINOR HEADER subfile=["+ getMinorHeaders() +"]" : "")
    	;
    }	
}
