package com.agilex.healthcare.mobilehealthplatform.ovid.fmdomain;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

import com.medsphere.fileman.FMAnnotateFieldInfo;
import com.medsphere.fileman.FMField;
import com.medsphere.fileman.FMFile;
import com.medsphere.fileman.FMRecord;
import com.medsphere.fileman.FMResultSet;

public class FMLabReport extends FMRecord {
	/*-------------------------------------------------------------
	 * begin static initialization
	 *-------------------------------------------------------------*/
	private static Set<FMField> domainFields;
	private static FMFile fileInfo;
	private static Map<String, AnnotatedElement> domainJavaFields;
	private static Map<String, String> domainNumbers;

	static {
		domainJavaFields = getDomainJavaFields(FMLabReport.class);
		domainFields = getFieldsInDomain(domainJavaFields);
		domainNumbers = getNumericMapping(FMLabReport.class);
		fileInfo = new FMFile("64.5") {
			@Override
			public Collection<FMField> getFields() {
				return domainFields;
			}
		};
		fileInfo.setPack(true);

	}

	public static FMFile getFileInfoForClass() {
		return fileInfo;
	}

	@Override
	protected Set<FMField> getDomainFields() {
		return domainFields;
	}

	@Override
	protected Map<String, AnnotatedElement> getDomainJavaFields() {
		return domainJavaFields;
	}

	@Override
	protected Map<String, String> getNumericMapping() {
		return domainNumbers;
	}

	/*-------------------------------------------------------------
	 * end static initialization
	 *-------------------------------------------------------------*/

	@FMAnnotateFieldInfo(name = "NAME", number = ".01", fieldType = FMField.FIELDTYPE.FREE_TEXT)
	protected String name;

    @FMAnnotateFieldInfo( name="MAJOR HEADER", number="10", fieldType=FMField.FIELDTYPE.SUBFILE)
    protected FMLabReportHeader majorHeader;

    protected Collection<FMLabReportHeader> majorHeaders = null;   
    
    public FMLabReport() {
        super(fileInfo.getFileName());
    }
    
	public FMLabReport(FMResultSet results) {
		super(fileInfo.getFileName());
		//super(results);
		processResults(results);
	}

	public String getName() {
		return name;
	}

    public FMLabReportHeader getMajorHeader() {
        if (majorHeader == null) {
        	majorHeader = new FMLabReportHeader();
            majorHeader.setParent( this );
        }
        return majorHeader;
    }

    public void addMajorHeader(FMLabReportHeader majorHeader) {
        if (majorHeaders == null) {
        	majorHeaders = new ArrayList<FMLabReportHeader>();
        }
        majorHeaders.add(majorHeader);
    }

    public Collection<FMLabReportHeader> getMajorHeaders() {
        return majorHeaders;
    }
    
    @Override
    public String toString() {
    	return "[FMLabReport] IEN=" + getIEN()
        	+ ((getName() != null) ? " name=["+ getName() +"]" : "")
        	+ ((majorHeaders != null) ? " MAJOR HEADER subfile="+ getMajorHeaders() : "")
       ;
    }	
}
