package com.agilex.healthcare.mobilehealthplatform.ovid.domain;

import com.agilex.healthcare.mobilehealthplatform.ovid.fmdomain.FMTopographyField;
import com.medsphere.common.cache.GenericCache;

/**
 * Cache for specimen records with specimen names as primary keys.
 * 
 * @author kim
 *
 */
public class OvidTopographyCache extends
		GenericCache<String, FMTopographyField> {

	private static OvidTopographyCache instance = null;

	private OvidTopographyCache(long shelfLife) {
		super();
		setShelfLifeInMilliseconds(shelfLife);
	}

//	private final static long fiveMinutes = 5 * 60 * 1000L;
//	private final static long oneHour = 60 * 60 * 1000L;
	private final static long oneDay = 24 * 60 * 60 * 1000L;
	
	public static synchronized OvidTopographyCache getInstance() {
		if (instance == null) {
			instance = new OvidTopographyCache(oneDay);
		}
		return instance;
	}
}