package com.agilex.healthcare.mobilehealthplatform.ovid.domain;

import java.io.Serializable;

public class OvidTestResult implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7870890284822418679L;
	
	protected String testName;	
	protected String testId;
	protected String value;
	protected String units;
	protected String referenceRange;
	protected String indicator;
	protected String refLow;
	protected String refHi;
    
	public OvidTestResult() {}
	
	public OvidTestResult(String testName, String testId, String value, String units, 
			String referenceRange, String indicator) {
		super();
		this.testName = testName;
		this.testId = testId;
		this.value = value;
		this.units = units;
		this.referenceRange = referenceRange;
		this.indicator = indicator;
	}
	
	public String getTestName() {
		return testName;
	}
	public void setTestName(String testName) {
		this.testName = testName;
	}
	public String getTestId() {
		return testId;
	}
	public void setTestId(String testId) {
		this.testId = testId;
	}	
	public String getValue() {
		return value;
	}
	public void setValue(String value) {
		this.value = value;
	}
	public String getUnits() {
		return units;
	}
	public void setUnits(String units) {
		this.units = units;
	}
	public String getReferenceRange() {
		return referenceRange;
	}
	public void setReferenceRange(String referenceRange) {
		this.referenceRange = referenceRange;
	} 	
	public String getIndicator() {
		return indicator;
	}
	public void setIndicator(String indicator) {
		this.indicator = indicator;
	}

	public String getRefLow() {
		return refLow;
	}

	public void setRefLow(String refLow) {
		this.refLow = refLow;
	}

	public String getRefHi() {
		return refHi;
	}

	public void setRefHi(String refHi) {
		this.refHi = refHi;
	}

	@Override	
	public String toString() {
		StringBuffer str = new StringBuffer();		
		str.append("test=[" + testName + "] IEN=[" + testId + "] value=[" + value + "] units=[" + 
				units + "] low=[" + refLow + "] high=[" + refHi + "] ranges=[" + referenceRange + 
				"] indicator=[" + indicator + "]");	
	
		return str.toString();
	}
}
