package com.agilex.healthcare.mobilehealthplatform.ovid.domain;

import java.io.Serializable;
import java.util.Date;

public class OvidMicroLabResult implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 3065908366171398687L;
	protected Date resultedDate;
	protected Date collectionDTM;
	protected String accessionNumber;
	protected String collectionSample;
	protected String specimen;
	protected String specimenId;
	protected String labType;
	protected String testName;
	protected String testId;
	protected String status;
	protected String orderId;
	protected StringBuffer text = new StringBuffer();

	public Date getResultedDate() {
		return resultedDate;
	}

	public void setResultedDate(Date resultedDate) {
		this.resultedDate = resultedDate;
	}

	public Date getCollectionDTM() {
		return collectionDTM;
	}

	public void setCollectionDTM(Date collectionDTM) {
		this.collectionDTM = collectionDTM;
	}

	public String getAccessionNumber() {
		return accessionNumber;
	}

	public void setAccessionNumber(String accessionNumber) {
		this.accessionNumber = accessionNumber;
	}

	public String getCollectionSample() {
		return collectionSample;
	}

	public void setCollectionSample(String collectionSample) {
		this.collectionSample = collectionSample;
	}

	public String getSpecimen() {
		return specimen;
	}

	public void setSpecimen(String specimen) {
		this.specimen = specimen;
	}

	public String getSpecimenId() {
		return specimenId;
	}

	public void setSpecimenId(String specimenId) {
		this.specimenId = specimenId;
	}

	public String getLabType() {
		return labType;
	}

	public void setLabType(String labType) {
		this.labType = labType;
	}

	public String getTestName() {
		return testName;
	}

	public void setTestName(String testName) {
		this.testName = testName;
	}

	public String getTestId() {
		return testId;
	}

	public void setTestId(String testId) {
		this.testId = testId;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getText() {
		return text.toString();
	}

	public void appendText(String text) {
		if (text == null)
			this.text = new StringBuffer();
		this.text.append(text + System.getProperty("line.separator"));
	}

	@Override
	public String toString() {
		StringBuffer str = new StringBuffer();
		str.append("type=[single] group=[" + labType + "] accessionNumber=[" + accessionNumber + "] specimen=[" + specimenId + ":" + specimen + "] test=[" + testName + ":" + testId + "] status=["
				+ status + "] collectionDTM=[" + collectionDTM + "] resultedDate=[" + resultedDate + "] order=[" + orderId + "] text=[" + text + "]");

		return str.toString();
	}

}
