package com.agilex.healthcare.mobilehealthplatform.ovid.domain;

import com.medsphere.common.cache.GenericCache;
import com.medsphere.fmdomain.FMLaboratoryTest;

/**
 * Cache for lab test records with lab test identifiers as primary keys.
 * 
 * @author kim
 *
 */
public class OvidLabTestCache extends GenericCache<String, FMLaboratoryTest> {

	private static OvidLabTestCache instance = null;

	private OvidLabTestCache(long shelfLife) {
		super();
		setShelfLifeInMilliseconds(shelfLife);
	}

//	private final static long fiveMinutes = 5 * 60 * 1000L;
//	private final static long oneHour = 60 * 60 * 1000L;
	private final static long oneDay = 24 * 60 * 60 * 1000L;

	public static synchronized OvidLabTestCache getInstance() {
		if (instance == null) {
			instance = new OvidLabTestCache(oneDay);
		}
		return instance;
	}
}
