package com.agilex.healthcare.mobilehealthplatform.ovid.domain;

import java.io.Serializable;

public class OvidLabTest implements Serializable {

	private static final long serialVersionUID = -7951891111986970816L;
	
	/** unique identifier of this lab test */
	private String id;
	/** name of test  */
	private String testName;
	/** type of specimen */
	private String specimen;
	private String specimenId;
	private String units;
	private String lowReferenceRange;
	private String hiReferenceRange;
	private String shortName;
	protected String labType;
	
	public OvidLabTest(String id, String testName) {
		this.id = id;
		this.testName = testName;
	}
	
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}

	public String getTestName() {
		return testName;
	}
	public void setTestName(String testName) {
		this.testName = testName;
	}

	public String getSpecimen() {
		return specimen;
	}
	public void setSpecimen(String specimen) {
		this.specimen = specimen;
	}
	public String getSpecimenId() {
		return specimenId;
	}
	public void setSpecimenId(String specimenId) {
		this.specimenId = specimenId;
	}
	public String getUnits() {
		return units;
	}
	public void setUnits(String units) {
		this.units = units;
	}
	public String getLowReferenceRange() {
		return lowReferenceRange;
	}
	public void setLowReferenceRange(String lowReferenceRange) {
		this.lowReferenceRange = lowReferenceRange;
	}
	public String getHiReferenceRange() {
		return hiReferenceRange;
	}
	public void setHiReferenceRange(String hiReferenceRange) {
		this.hiReferenceRange = hiReferenceRange;
	}
	public String getLabType() {
		return labType;
	}
	public void setLabType(String labType) {
		this.labType = labType;
	}	
	
	public String getShortName() {
		return shortName;
	}

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	@Override
	public String toString() {
		return "test=[" + id + ":" + testName + "] specimen=[" + specimenId + ":" + specimen + "] type=[" + labType
				+ "] units=[" + units + "] low range=[" + lowReferenceRange + "] hi range=[" + hiReferenceRange 
				+ "] shortName=[" + shortName +"]";
	}
}
