package com.agilex.healthcare.mobilehealthplatform.ovid.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class OvidLabResult implements Serializable {
	
	/**
	 * 
	 */
	protected static final long serialVersionUID = 5214185290116864922L;
	protected Date resultedDate;
	protected Date collectionDTM;
	protected String accessionNumber;
	protected String specimen;
	protected String specimenId;
	protected String labType;
	protected String status;
	protected String orderId;
	protected String comment;
	protected String text;
	
	protected Collection<OvidTestResult> results;
    
	public Date getResultedDate() {
		return resultedDate;
	}
	public void setResultedDate(Date resultedDate) {
		this.resultedDate = resultedDate;
	}
	
	public Date getCollectionDTM() {
		return collectionDTM;
	}
	public void setCollectionDTM(Date collectionDTM) {
		this.collectionDTM = collectionDTM;
	}
	public String getAccessionNumber() {
		return accessionNumber;
	}
	public void setAccessionNumber(String accessionNumber) {
		this.accessionNumber = accessionNumber;
	}   	
	public String getSpecimen() {
		return specimen;
	}
	public void setSpecimen(String specimen) {
		this.specimen = specimen;
	}
	
	public String getSpecimenId() {
		return specimenId;
	}
	public void setSpecimenId(String specimenId) {
		this.specimenId = specimenId;
	}
	
	public String getLabType() {
		return labType;
	}
	public void setLabType(String labType) {
		this.labType = labType;
	}	

	public String getStatus() {
		return status;
	}
	public void setStatus(String status) {
		this.status = status;
	}	
	
	public String getOrderId() {
		return orderId;
	}
	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}
	
	public Collection<OvidTestResult> getResults() {
		if (results == null) {
			results = new ArrayList<OvidTestResult>();
		}
		
		return results;
	}
	public void setResults(Collection<OvidTestResult> results) {
		this.results = results;
	}
	
	public String getComment() {
		return comment;
	}
	public void setComment(String comment) {
		this.comment = comment;
	}
	
	public String getText() {
		return text;
	}
	public void setText(String text) {
		this.text = text;
	}
	
	@Override
	public String toString() {
		StringBuffer str = new StringBuffer();
		str.append("type=[single] group=[" + labType 
				+ "] accessionNumber=[" + accessionNumber 
				+ "] specimen=[" + specimenId + ":" + specimen 
				+ "] status=[" + status 
				+ "] resultedDate=[" + resultedDate 
				+ "] order=[" + orderId + "]");
		for (OvidTestResult result : getResults()) {
			str.append("\n\t" + result.toString());
		}

		return str.toString();
	}	
}
