package com.agilex.healthcare.mobilehealthplatform.ovid.domain;


public class OvidBatteryLabResult extends OvidLabResult {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5826052530489769458L;

	protected String batteryTestName;	
	protected String batteryTestIEN;
	protected String batteryLoincCode;	 

	public OvidBatteryLabResult() {
		super();
	}
	
	public String getBatteryTestName() {
		return batteryTestName;
	}

	public void setBatteryTestName(String batteryTestName) {
		this.batteryTestName = batteryTestName;
	}

	public String getBatteryTestIEN() {
		return batteryTestIEN;
	}

	public void setBatteryTestIEN(String batteryTestIEN) {
		this.batteryTestIEN = batteryTestIEN;
	}

	public String getBatteryLoincCode() {
		return batteryLoincCode;
	}

	public void setBatteryLoincCode(String batteryLoincCode) {
		this.batteryLoincCode = batteryLoincCode;
	}  

	@Override
	public String toString() {
		StringBuffer str = new StringBuffer();
		str.append("type=[battery] resultedDate=[" + resultedDate + "] accessionNumber=[" + accessionNumber + 
				" ] panel test=[" + batteryTestName + "] panel ien=[" + batteryTestIEN + 
				"] panel loincCode=[" + batteryLoincCode + "] ");
		str.append("group=[" + labType + "] status=[" + status + "] order=[" + orderId + "]");
		for (OvidTestResult result : getResults()) {
			str.append("\n\t" + result.toString());
		}	

		return str.toString();
	}

}
