package com.agilex.healthcare.mobilehealthplatform.ovid;

import com.medsphere.ovid.domain.ov.OvidSecureRepository;
import com.medsphere.vistarpc.RPCConnection;
import com.medsphere.vistarpc.RPCException;

public class OvidConnectionAwareRepository extends OvidSecureRepository {

	private final static org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(OvidConnectionAwareRepository.class);

	protected RPCConnection connection;
	protected RPCConnection serverConnection;

	public OvidConnectionAwareRepository(RPCConnection connection) {
		super(connection);
		this.connection = connection;
	}

	public OvidConnectionAwareRepository(RPCConnection connection, RPCConnection serverConnection) {
		super(connection, serverConnection);
		this.connection = connection;
		this.serverConnection = serverConnection;
	}

	public void close() {
		if (connection != null) {
			try {
				connection.close();
				connection = null;
			} catch (RPCException ignore) {
				// ignore
			}
		}
		if (serverConnection != null) {
			try {
				serverConnection.close();
				serverConnection = null;
			} catch (RPCException ignore) {
				// ignore
			}
		}
	}

	@Override
	protected void finalize() throws Throwable {
		if (connection != null || serverConnection != null) {
			logger.debug("Connection was not closed, closing connection now.");
			close();
		}
	}
}
