package com.agilex.healthcare.mobilehealthplatform.ovid;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.ovid.domain.OvidImageMetadata;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.ListHelper;
import com.medsphere.ovid.domain.ov.OvidDomainException;
import com.medsphere.ovid.domain.ov.OvidSecureRepository;
import com.medsphere.vistarpc.RPCConnection;
import com.medsphere.vistarpc.RPCException;
import com.medsphere.vistarpc.RPCResponse;
import com.medsphere.vistarpc.RPCResponse.ResponseType;
import com.medsphere.vistarpc.VistaRPC;

public class ImageMetadataRepository extends OvidSecureRepository {

	private final static String MAGG_IMAGE_INFO = "MAGG IMAGE INFO";
	private final static String MAGG_PAT_IMAGES = "MAGG PAT IMAGES";
	private final static String RPC_CONTEXT = "OR CPRS GUI CHART";
	private final static org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory
			.getLog(ImageMetadataRepository.class);

	public ImageMetadataRepository(RPCConnection connection) {
		super(connection);
	}

	public List<OvidImageMetadata> getImageMetadata(String patientId) throws OvidDomainException {
		logger.info("get metadata for patient id " + patientId);
		final int IMAGEID_INDEX = 1;
		final int IMAGEURL_INDEX = 2;
		final int DESCRIPTION_INDEX = 4;
		final int TYPE_INDEX = 7;
		final int DATEUPLOADED_INDEX = 5;
		List<OvidImageMetadata> images = new LinkedList<OvidImageMetadata>();

		VistaRPC rpc = new VistaRPC(MAGG_PAT_IMAGES, ResponseType.ARRAY);
		RPCConnection rpcConnection;
		try {
			rpcConnection = getConnection();
			rpcConnection.setContext(RPC_CONTEXT);
		} catch (RPCException e) {
			logger.error("Exception while setting the context", e);
			throw new OvidDomainException(e);
		}

		rpc.setParam(1, patientId);
		RPCResponse response = null;
		try {
			response = rpcConnection.execute(rpc);
		} catch (RPCException e) {
			logger.error("Exception while executing RPC \"" + MAGG_PAT_IMAGES + "\"", e);
			throw new OvidDomainException(e);
		}

		if (response.getError() == null || response.getError().isEmpty()) {
			String items[] = response.getArray();
			if (isEmptyResult(items)) {
				logger.info("Empty image list");
				return images;
			} else {
				for (String item : items) {
					logger.debug(item);
					String parts[] = item.split("\\^");
					if (parts.length < 3) {
						continue;
					}
					String imageId = ListHelper.getValue(parts, IMAGEID_INDEX);					
					String imageUrl = ListHelper.getValue(parts, IMAGEURL_INDEX);
					String description = ListHelper.getValue(parts, DESCRIPTION_INDEX);
					String type = ListHelper.getValue(parts, TYPE_INDEX);
					String dateUploadedText = ListHelper.getValue(parts, DATEUPLOADED_INDEX);
					Date dateUploaded =  DateHelper.parseVistaDate(dateUploadedText);
					OvidImageMetadata image = new OvidImageMetadata();
					image.setImageId(imageId);
					image.setImageUrl(imageUrl);
					image.setDescription(description);
					image.setType(type);
					image.setDateUploaded(dateUploaded);
					images.add(image);			
				}
			}
			return images;
		} else {
			logger.error(response.getError());
			throw new OvidDomainException(response.getError());
		}
	}

	public OvidImageMetadata getImageMetadataDetail(String imageId) throws OvidDomainException {
		logger.info("get metadata for image id " + imageId);
		final int IMAGEURL_INDEX = 2;
		final int DESCRIPTION_INDEX = 4;
		final int TYPE_INDEX = 7;
		final int DATEUPLOADED_INDEX = 5;
		
		VistaRPC rpc = new VistaRPC(MAGG_IMAGE_INFO, ResponseType.ARRAY);
		RPCConnection rpcConnection;
		try {
			rpcConnection = getConnection();
			rpcConnection.setContext(RPC_CONTEXT);
		} catch (RPCException e) {
			logger.error("Exception while setting the context", e);
			throw new OvidDomainException(e);
		}

		rpc.setParam(1, imageId);
		RPCResponse response = null;
		try {
			response = rpcConnection.execute(rpc);
		} catch (RPCException e) {
			logger.error("Exception while executing RPC \"" + MAGG_IMAGE_INFO + "\"", e);
			throw new OvidDomainException(e);
		}

		if (response.getError() == null || response.getError().isEmpty()) {
			String items[] = response.getArray();
			if (isEmptyResult(items)) {
				logger.info("Empty image detail");
				return null;
			} else {
				for (String item : items) {
					logger.debug(item);
					String parts[] = item.split("\\^");
					if (parts.length < 3) {
						continue;
					}
					String imageUrl = ListHelper.getValue(parts, IMAGEURL_INDEX);
					String description = ListHelper.getValue(parts, DESCRIPTION_INDEX);
					String type = ListHelper.getValue(parts, TYPE_INDEX);
					String dateUploadedText = ListHelper.getValue(parts, DATEUPLOADED_INDEX);
					Date dateUploaded =  DateHelper.parseVistaDate(dateUploadedText);
					OvidImageMetadata image = new OvidImageMetadata();
					image.setImageId(imageId);
					image.setImageUrl(imageUrl);
					image.setDescription(description);
					image.setType(type);
					image.setDateUploaded(dateUploaded);
					return image;
				}
			}
			return null;
		} else {
			logger.error(response.getError());
			throw new OvidDomainException(response.getError());
		}
	}

}
