package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.pooled;

public class ValidateConnectionEvent implements PoolEventCallback<RPCBrokerPooledConnection> {

	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(ValidateConnectionEvent.class);
	
	private OvidConnectionManagerWithPooling connectionManager;
	
	public ValidateConnectionEvent(OvidConnectionManagerWithPooling connectionManager) {
		this.connectionManager = connectionManager;
	}
	
	@Override
	public boolean event(RPCBrokerPooledConnection connection) {
		logger.debug("Keep alive connection " + connection.toString());
		boolean isValid = connectionManager.validateConnection(connection);
		if (!isValid) {
			connectionManager.releaseConnection(connection);
		}
		return isValid;
	}
}
