package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.pooled;

import com.medsphere.vistarpc.RPCBrokerConnection;
import com.medsphere.vistarpc.RPCException;
import com.medsphere.vistarpc.RPCResponse;
import com.medsphere.vistarpc.VistaRPC;

/**
 * RPCBrokerConnection that is connection pool aware. Closing this connection
 * will return the connection to the pool.
 * 
 */
public class RPCBrokerPooledConnection extends RPCBrokerConnection {

	private final static org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(RPCBrokerPooledConnection.class);

	private OvidConnectionManagerWithPooling source;
	private String type;

	/**
	 * 
	 * @param host
	 * @param port
	 * @param access
	 * @param verify
	 * @param source
	 *            The connection pool
	 * @param type
	 *            A server or user connection type
	 * @throws RPCException
	 */
	public RPCBrokerPooledConnection(String host, int port, String access, String verify, OvidConnectionManagerWithPooling source, String type) throws RPCException {
		super(host, port, access, verify);
		this.source = source;
		this.type = type;
	}

	/**
	 * 
	 * @param host
	 * @param port
	 * @param token
	 * @param source
	 *            The connection pool
	 * @param type
	 *            A server or user connection type
	 * @throws RPCException
	 */
	public RPCBrokerPooledConnection(String host, int port, String token, OvidConnectionManagerWithPooling source, String type) throws RPCException {
		super(host, port, token);
		this.source = source;
		this.type = type;
	}

	/**
	 * Returns the connection to the pool to be available
	 */
	@Override
	public void close() throws RPCException {
		// return to pool
		logger.debug("returning connection to the pool");
		source.releaseConnection(this);
	}

	public String getType() {
		return type;
	}

	public void terminate() throws RPCException {
		logger.debug("terminating connection");
		super.close();
	}

	@Override
	public RPCResponse execute(VistaRPC paramVistaRPC) throws RPCException {
		RPCResponse response = null;

		logger.debug("invoking " + paramVistaRPC);
		response = super.execute(paramVistaRPC);
		logger.debug("invoke complete " + paramVistaRPC);

		return response;
	}
}
