package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.cached;

import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.AbstractConnectionManager;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.OvidConfiguration;
import com.medsphere.ovid.domain.ov.OvidSecureRepository;
import com.medsphere.vistarpc.RPCConnection;

public class OvidConnectionManagerWithCache extends AbstractConnectionManager {

	public OvidConnectionManagerWithCache(OvidConfiguration configuration) {
		super(configuration);
	}

	private static RPCConnection cachedUserConnection;
	private static RPCConnection cachedServerConnection;

	@Override
	public RPCConnection getUserConnection()   {
		if (cachedUserConnection == null)
			cachedUserConnection = super.getUserConnection();
		return cachedUserConnection;
	}
	

	@Override
	public RPCConnection getServerConnection()   {
		if (cachedServerConnection == null)
			cachedServerConnection = super.getServerConnection();
		return cachedServerConnection;
	}
	
	@Override
	public void releaseRepositoryConnections(OvidSecureRepository repository) {
	}


}