package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement;

import java.util.Map;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class OvidConfiguration {
	private String server;
	private int port;
	private String userAccessCode;
	private String userVerifyCode;
	private String ovidAccessCode;
	private String ovidVerifyCode;
	private boolean usePool = false;
	private int initialServerConnections = 0;
	private int initialUserConnections = 0;
	private int maxFreeUserConnections = 10;
	private int maxFreeServerConnections = 10;
	
	private boolean validateReusedConnections = false;
	private boolean keepFreeConnectionsAlive = true;
	private boolean keepAllConnectionsAlive = false;
	private int secondsBetweenConnnectionRefresh = 150;
	
	public void load() {
		BeanFactory beanFactory;

		ClassPathXmlApplicationContext appContext = new ClassPathXmlApplicationContext(new String[] { "ovidConfiguration.xml" });
		beanFactory = (BeanFactory) appContext;

		@SuppressWarnings("unchecked")
		Map<String, String> ovidProperties = (Map<String, String>) beanFactory.getBean("ovidConnectionProperites");

		server = ovidProperties.get("server");
		port = Integer.parseInt(ovidProperties.get("port"));
		userAccessCode = ovidProperties.get("userAccessCode");
		userVerifyCode = ovidProperties.get("userVerifyCode");
		ovidAccessCode = ovidProperties.get("ovidAccessCode");
		ovidVerifyCode = ovidProperties.get("ovidVerifyCode");
		if (ovidProperties.get("usePool") != null && ovidProperties.get("usePool").equalsIgnoreCase("true")) {
			usePool = true;
		}
		if (ovidProperties.get("initialUserConnections")!= null) {
			String text =  ovidProperties.get("initialUserConnections");
			initialUserConnections = Integer.parseInt(text);
		}
		
		if (ovidProperties.get("initialServerConnections")!= null) {
			String text =  ovidProperties.get("initialServerConnections");
			initialServerConnections = Integer.parseInt(text);
		}
		
		if (ovidProperties.get("maxFreeUserConnections")!= null) {
			String text =  ovidProperties.get("maxFreeUserConnections");
			maxFreeUserConnections = Integer.parseInt(text);
		}
		if (ovidProperties.get("maxFreeServerConnections")!= null) {
			String text =  ovidProperties.get("maxFreeServerConnections");
			maxFreeServerConnections = Integer.parseInt(text);
		}		
	}

	public String getServer() {
		return server;
	}

	public int getPort() {
		return port;
	}

	public String getUserAccessCode() {
		return userAccessCode;
	}

	public String getUserVerifyCode() {
		return userVerifyCode;
	}

	public String getOvidAccessCode() {
		return ovidAccessCode;
	}

	public String getOvidVerifyCode() {
		return ovidVerifyCode;
	}

	public void setServer(String server) {
		this.server = server;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public void setUserAccessCode(String userAccessCode) {
		this.userAccessCode = userAccessCode;
	}

	public void setUserVerifyCode(String userVerifyCode) {
		this.userVerifyCode = userVerifyCode;
	}

	public void setOvidAccessCode(String ovidAccessCode) {
		this.ovidAccessCode = ovidAccessCode;
	}

	public void setOvidVerifyCode(String ovidVerifyCode) {
		this.ovidVerifyCode = ovidVerifyCode;
	}

	public boolean isUsePool() {
		return usePool;
	}

	public void setUsePool(boolean usePool) {
		this.usePool = usePool;
	}

	public int getInitialServerConnections() {
		return initialServerConnections;
	}

	public void setInitialServerConnections(int initialServerConnections) {
		this.initialServerConnections = initialServerConnections;
	}

	public int getInitialUserConnections() {
		return initialUserConnections;
	}

	public void setInitialUserConnections(int initialUserConnections) {
		this.initialUserConnections = initialUserConnections;
	}

	public int getMaxFreeUserConnections() {
		return maxFreeUserConnections;
	}

	public void setMaxFreeUserConnections(int maxFreeUserConnections) {
		this.maxFreeUserConnections = maxFreeUserConnections;
	}

	public int getMaxFreeServerConnections() {
		return maxFreeServerConnections;
	}

	public void setMaxFreeServerConnections(int maxFreeServerConnections) {
		this.maxFreeServerConnections = maxFreeServerConnections;
	}

	public boolean isValidateReusedConnections() {
		return validateReusedConnections;
	}

	public void setValidateReusedConnections(boolean validateReusedConnections) {
		this.validateReusedConnections = validateReusedConnections;
	}

	public boolean isKeepFreeConnectionsAlive() {
		return keepFreeConnectionsAlive;
	}

	public void setKeepFreeConnectionsAlive(boolean keepFreeConnectionsAlive) {
		this.keepFreeConnectionsAlive = keepFreeConnectionsAlive;
	}

	public boolean isKeepAllConnectionsAlive() {
		return keepAllConnectionsAlive;
	}

	public void setKeepAllConnectionsAlive(boolean keepAllConnectionsAlive) {
		this.keepAllConnectionsAlive = keepAllConnectionsAlive;
	}

	public int getSecondsBetweenConnnectionRefresh() {
		return secondsBetweenConnnectionRefresh;
	}

	public void setSecondsBetweenConnnectionRefresh(int secondsBetweenConnnectionRefresh) {
		this.secondsBetweenConnnectionRefresh = secondsBetweenConnnectionRefresh;
	}	
	
	

}
