package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement;

import com.agilex.healthcare.mobilehealthplatform.ovid.HospitalLocationRepository;
import com.agilex.healthcare.mobilehealthplatform.ovid.LabResultRepository;
import com.agilex.healthcare.mobilehealthplatform.ovid.LabTestRepository;
import com.agilex.healthcare.mobilehealthplatform.ovid.MedicationRepository;
import com.agilex.healthcare.mobilehealthplatform.ovid.OvidPatientRepository;
import com.agilex.healthcare.mobilehealthplatform.ovid.TopographyFieldRepository;
import com.agilex.healthcare.mobilehealthplatform.ovid.VitalSignRepository;
import com.medsphere.ovid.domain.ov.OvidSecureRepository;
import com.medsphere.ovid.domain.ov.PatientItemRepository;
import com.medsphere.ovid.domain.ov.PatientMovementRepository;
import com.medsphere.ovid.domain.ov.PatientRepository;
import com.medsphere.ovid.domain.ov.ProblemRepository;
import com.medsphere.vistarpc.RPCConnection;

public interface IOvidConnectionManager {
	public abstract RPCConnection getUserConnection();

	public abstract RPCConnection getServerConnection();

	public abstract PatientItemRepository getPatientItemRepository(String rpcContext);

	public abstract PatientItemRepository getProblemPatientItemRepository();

	public abstract ProblemRepository getProblemRepository();

	public abstract PatientRepository getPatientRepository();

	public abstract OvidPatientRepository getOvidPatientRepository();

	public abstract PatientItemRepository getAllergyRepository();

	public abstract MedicationRepository getMedicationRepository();

	public abstract LabResultRepository getLabResultRepository();

	public abstract LabTestRepository getLabTestRepository();

	public abstract HospitalLocationRepository getHospitalLocationRepository();

	public abstract VitalSignRepository getVitalSignRepository();

	public abstract void releaseRepositoryConnections(OvidSecureRepository repository);

	public abstract void releaseConnection(RPCConnection connection);

	public abstract PatientMovementRepository getPatientMovementRepository();
	
	public TopographyFieldRepository getTopographyFieldRepository();
}
