package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement;

import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.basic.OvidConnectionManagerBasic;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.pooled.OvidConnectionManagerWithPooling;
import com.agilex.healthcare.mobilehealthplatform.healthcheck.SystemProperties;

public class ConnectionManagerFactory {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(ConnectionManagerFactory.class);

	private static OvidConfiguration configuration = null;
	private static IOvidConnectionManager connectionManager;

	public static IOvidConnectionManager getInstance() {
		if (connectionManager != null) {
			logger.debug("returning cached instance of connection manager. " + connectionManager.toString());
			return connectionManager;
		}
		if (configuration == null) {
			configuration = getConfiguration();
			recordConfigurationToMetrics(configuration);
		}
		logger.debug("ConnectionPool=" + configuration.isUsePool());
		if (configuration.isUsePool()) {
			connectionManager = new OvidConnectionManagerWithPooling(configuration);
			logger.info("created new instance of connection manager. " + connectionManager.toString());
			return connectionManager;
		} else {
			logger.debug("creating new instance of OvidConnectionManagerNoCache");
			return new OvidConnectionManagerBasic(configuration);
			// return new OvidConnectionManagerCache(configuration);
		}
	}

	private static void recordConfigurationToMetrics(OvidConfiguration configuration) {
		SystemProperties.setValue("ovid-cm-" + "server" + "-config-initialserverconnections", Integer.toString(configuration.getInitialServerConnections()));
		SystemProperties.setValue("ovid-cm-" + "server" + "-config-maxfreeserverconnections", Integer.toString(configuration.getMaxFreeServerConnections()));
		SystemProperties.setValue("ovid-cm-" + "server" + "-config-accesscode", configuration.getOvidAccessCode());
		SystemProperties.setValue("ovid-cm-" + "server" + "-config-verifycode", "*****");
		SystemProperties.setValue("ovid-cm-" + "server" + "-config-server", configuration.getServer());
		SystemProperties.setValue("ovid-cm-" + "server" + "-config-post", Integer.toString(configuration.getPort()));
		SystemProperties.setValue("ovid-cm-" + "user" + "-config-initialserverconnections", Integer.toString(configuration.getInitialUserConnections()));
		SystemProperties.setValue("ovid-cm-" + "user" + "-config-maxfreeserverconnections", Integer.toString(configuration.getMaxFreeUserConnections()));
		SystemProperties.setValue("ovid-cm-" + "user" + "-config-accesscode", configuration.getUserAccessCode());
		SystemProperties.setValue("ovid-cm-" + "user" + "-config-verifycode", "*****");
		SystemProperties.setValue("ovid-cm-" + "user" + "-config-server", configuration.getServer());
		SystemProperties.setValue("ovid-cm-" + "user" + "-config-post", Integer.toString(configuration.getPort()));
	}

	public static void setConfiguration(OvidConfiguration userConfiguration) {
		configuration = userConfiguration;
	}

	public static OvidConfiguration getConfiguration() {
		if (configuration == null) {
			configuration = new OvidConfiguration();
			configuration.load();
		}
		return configuration;
	}
}
