package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid;

import java.util.Collection;
import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.ConnectionManagerFactory;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.IOvidConnectionManager;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalSign;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalSigns;
import com.agilex.healthcare.mobilehealthplatform.ovid.VitalSignRepository;
import com.medsphere.ovid.domain.ov.IsAVitalSign;
import com.medsphere.ovid.domain.ov.OvidDomainException;

public class VitalDataLayerOvid {
	private static final Log logger = LogFactory.getLog(VitalDataLayerOvid.class);

	public VitalSigns getMostRecentVitalSigns(String patientId) {
		logger.info(String.format("begin getMostRecentVitalSigns [patientId=%s]", patientId));

		IOvidConnectionManager connectionManager = ConnectionManagerFactory.getInstance();
		VitalSignRepository repo = connectionManager.getVitalSignRepository();

		Collection<IsAVitalSign> vitalSignList = null;
		try {
			vitalSignList = repo.getMostRecentVitalSigns(patientId);
		} catch (OvidDomainException e) {
			logger.error("Exception while retrieving medications for patient id: " + patientId, e);
			throw new RuntimeException(e);
		} finally {
			connectionManager.releaseRepositoryConnections(repo);
		}
		VitalSigns vitalSigns = new VitalSigns();
		for (IsAVitalSign isAVitalSign : vitalSignList) {
			vitalSigns.add(translateVitalSign(isAVitalSign, patientId));
		}

		logger.debug(String.format("retrieved %s records.", vitalSigns.size()));
		return vitalSigns;
	}

	public VitalSigns getVitalSigns(String patientId, Date startDate, Date endDate) {
		IOvidConnectionManager connectionManager = ConnectionManagerFactory.getInstance();
		VitalSignRepository repo = connectionManager.getVitalSignRepository();

		Collection<IsAVitalSign> vitalSignList = null;
		try {
			vitalSignList = repo.getVitalSigns(patientId, startDate, endDate);
		} catch (OvidDomainException e) {
			logger.error("Exception while retrieving medications for patient id: " + patientId, e);
			throw new RuntimeException(e);
		} finally {
			connectionManager.releaseRepositoryConnections(repo);
		}
		VitalSigns vitalSigns = new VitalSigns();
		for (IsAVitalSign isAVitalSign : vitalSignList) {
			vitalSigns.add(translateVitalSign(isAVitalSign, patientId));
		}

		logger.debug(String.format("retrieved %s records.", vitalSigns.size()));
		return vitalSigns;
	}

	private VitalSign translateVitalSign(IsAVitalSign isAVitalSign, String patientId) {
		VitalSign vitalSign = new VitalSign();
		vitalSign.setPatientId(patientId);
		vitalSign.setValue(isAVitalSign.getValue());
		vitalSign.setValueUnits(isAVitalSign.getUnits());
		vitalSign.setMeasuredDate(isAVitalSign.getDateTaken());
		vitalSign.setVitalId(isAVitalSign.getIEN());
		vitalSign.setVitalType(isAVitalSign.getType());
		return vitalSign;
	}

}
