package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid;

import java.util.Collection;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.ConnectionManagerFactory;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.IOvidConnectionManager;
import com.agilex.healthcare.mobilehealthplatform.datalayer.problem.ProblemDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.utility.NullChecker;
import com.medsphere.ovid.domain.ov.OvidDomainException;
import com.medsphere.ovid.domain.ov.PatientItemRepository;
import com.medsphere.ovid.model.domain.patient.PatientProblem;

public class ProblemDataLayerOpenSourceOvid implements ProblemDataLayer {
	private static final Log logger = LogFactory.getLog(ProblemDataLayerOpenSourceOvid.class);

	public Problems fetchProblems(String patientId) {
		Problems allProblems = getPatientProblems(patientId);
		Problems activeProblems = new Problems();
		for (Problem problem : allProblems) {
			if (problem.isActive()) {
				activeProblems.add(problem);
			}
		}
		return activeProblems;
	}

	private Problems getPatientProblems(String patientId) {
		IOvidConnectionManager connectionManager = ConnectionManagerFactory.getInstance();

		PatientItemRepository problemRepo = null;
		Problems problems = null;
		try {
			logger.info(String.format("retrieve problems [patient=%s]", patientId));
			problemRepo = connectionManager.getProblemPatientItemRepository();
			Collection<PatientProblem> ovidProblems = problemRepo.getProblems(patientId);
			logger.info(String.format("retrieved %s problems [patient=%s]", ovidProblems.size(), patientId));
			problems = transformFromOvidProblems(patientId, ovidProblems);
		} catch (OvidDomainException e) {
			throw new RuntimeException(e);
		} finally {
			connectionManager.releaseRepositoryConnections(problemRepo);
		}

		return problems;
	}

	private Problems transformFromOvidProblems(String patientId, Collection<PatientProblem> ovidProblems) {
		Problems problems = new Problems();
		for (PatientProblem ovidProblem : ovidProblems) {
			System.out.println("diagnosis: " + ovidProblem.getMessage());
			System.out.println("onset:" + ovidProblem.getDateTime());
			System.out.println("toString: " + ovidProblem.toString());

			Problem p = new Problem();
			p.setDescription(ovidProblem.getMessage());
			p.setOnsetDate(ovidProblem.getDateTime());
			p.setPatientId(patientId);
			// p.setResolutionDate(ovidProblem.getDateResolved());
			p.setProblemId(ovidProblem.getId());
			p.setPriority(ovidProblem.getStatus());
			p.setActive(calculateIsActive(ovidProblem.getStatus()));
			problems.add(p);
		}
		return problems;
	}

	private boolean calculateIsActive(String status) {
		boolean isActive;
		if (NullChecker.isNullish(status)) {
			isActive = true;
		} else if (status.toLowerCase().contentEquals("inactive")) {
			isActive = false;
		} else {
			isActive = true;
		}
		return isActive;
	}

	public Problems fetchProblems(String patientId, DateFilter dateFilter) {
		Problems problems = fetchProblems(patientId);
		return DateFilterer.filterByDate(problems, dateFilter);
	}

	@Override
	public Problems fetchProblems(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		return fetchProblems(patientIdentifier.getUniqueId(), dateFilter);
	}

}
