package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid;

import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.agilex.healthcare.mobilehealthplatform.ovid.domain.OvidMedication;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;

public class MedicationActiveCalculator {
	public static final String STATUS_ACTIVE = "ACTIVE";
	public static final String STATUS_ACTIVESUSPENDED = "ACTIVE/SUSP";
	public static final String STATUS_EXPIRED = "EXPIRED";
	public static final int MAX_NUMBER_DAYS_EXPIRED_TO_TREAT_AS_ACTIVE = 120;
	private static final Log logger = LogFactory.getLog(MedicationDataLayerOvid.class);
	private Date currentDate = null;

	public MedicationActiveCalculator() {
	}

	public MedicationActiveCalculator(Date currentDate) {
		this.currentDate = currentDate;
	}

	private Date getCurrentDate() {
		if (NullChecker.isNotNullish(this.currentDate))
			return this.currentDate;
		else
			return new Date();
	}

	public boolean determineIsActive(OvidMedication ovidMedication) {
		boolean isActive;
		final String status = ovidMedication.getStatus();
		if (STATUS_ACTIVE.equalsIgnoreCase(status)) {
			isActive = true;
			logger.debug(String.format("medication calcualted as active [status=%s][active=%s]", status, isActive));
		} else if (STATUS_ACTIVESUSPENDED.equalsIgnoreCase(status)) {
			isActive = true;
			logger.debug(String.format("medication calcualted as active [status=%s][active=%s]", status, isActive));
		} else if (STATUS_EXPIRED.equalsIgnoreCase(status)) {
			final Date now = getCurrentDate();
			final Date medicationStopDate = ovidMedication.getStopDate();
			if (NullChecker.isNotNullish(medicationStopDate)){
				int numberOfDaysExpired = DateHelper.calculateDeltaInDays(medicationStopDate, now);
				isActive = (numberOfDaysExpired <= MAX_NUMBER_DAYS_EXPIRED_TO_TREAT_AS_ACTIVE);
			}else{
				isActive = false;
			}
			logger.debug(String.format("medication active calculated  [status=%s][active=%s][stopDate=%s][currentDate=%s]", status, isActive, medicationStopDate, now));
		} else {
			isActive = false;
			logger.debug(String.format("medication active calculated [status=%s][active=%s]", status, isActive));
		}
		return isActive;
	}
}
