package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid;

import java.util.Collection;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.ConnectionManagerFactory;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.IOvidConnectionManager;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointment;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.ovid.HospitalLocationRepository;
import com.agilex.healthcare.mobilehealthplatform.ovid.domain.OvidAppointment;
import com.medsphere.ovid.domain.ov.OvidDomainException;

@Deprecated
public class AppointmentDataLayerRPCOvid implements AppointmentDataLayer {
	private static final Log logger = LogFactory.getLog(AppointmentDataLayerRPCOvid.class);

	@Override
	public Appointments getClinicAppointments(String clinicId, DateFilter dateFilter) {
		IOvidConnectionManager connectionManager = ConnectionManagerFactory.getInstance();

		HospitalLocationRepository repo = connectionManager.getHospitalLocationRepository();
		Collection<OvidAppointment> ovidResults;
		try {
			logger.info(String.format("retrieve appointments [clinic=%s][startdate=%s][enddate=%s]", clinicId, dateFilter.getStartDate(), dateFilter.getEndDate()));
			ovidResults = repo.getClinicAppointments(clinicId, dateFilter.getStartDate(), dateFilter.getEndDate());
			logger.info(String.format("retrieved %s appointments [clinic=%s][startdate=%s][enddate=%s]", ovidResults.size(), clinicId, dateFilter.getStartDate(), dateFilter.getEndDate()));
		} catch (OvidDomainException e) {
			throw new RuntimeException("Unable to retrieve clinic appointments", e);
		} finally {
			connectionManager.releaseRepositoryConnections(repo);
		}

		Appointments results = convertOvidAppointments(ovidResults);
		return results;
	}

	@Override
	public Appointments getProviderAppointments(String providerId, DateFilter dateFilter) {
		IOvidConnectionManager connectionManager = ConnectionManagerFactory.getInstance();

		HospitalLocationRepository repo = connectionManager.getHospitalLocationRepository();
		Collection<OvidAppointment> ovidResults;
		try {
			logger.info(String.format("retrieve appointments (rpc) [provider=%s][startdate=%s][enddate=%s]", providerId, dateFilter.getStartDate(), dateFilter.getEndDate()));
			repo.setUseRPC(true);
			ovidResults = repo.getProviderAppointments(providerId, dateFilter.getStartDate(), dateFilter.getEndDate());
			logger.info(String.format("retrieved %s appointments (rpc) [provider=%s][startdate=%s][enddate=%s]", ovidResults.size(), providerId, dateFilter.getStartDate(), dateFilter.getEndDate()));
		} catch (OvidDomainException e) {
			throw new RuntimeException("Unable to retrieve provider appointments", e);
		} finally {
			connectionManager.releaseRepositoryConnections(repo);
		}

		Appointments results = convertOvidAppointments(ovidResults);
		return results;
	}

	private Appointments convertOvidAppointments(Collection<OvidAppointment> ovidResults) {
		Appointments results = new Appointments();

		Appointment result;
		for (OvidAppointment entry : ovidResults) {
			result = new Appointment();
			result.setClinicName(entry.getClinicName());
			result.setAppointmentStartDate(entry.getAppointmentDTM());
			result.setAppointmentDuration(parseDuration(entry));
			result.setProviderName(entry.getProviderName());
			result.setPatientName(entry.getPatientName());
			result.setPatientSSN(entry.getPatientSSN());
			result.setReasonForVisit(entry.getAppointmentReason());
			results.add(result);
		}

		return results;
	}

	private Integer parseDuration(OvidAppointment entry) {

		Integer durationValue = 0;

		try {
			durationValue = Integer.parseInt(entry.getDuration());
		} catch (NumberFormatException e) {
			// if we can't parse duration we leave it at 0
		}

		return durationValue;
	}

    @Override
    public Appointments fetchAppointmentsByPatient(PatientIdentifier patientIdentifier, DateFilter filter) {
        throw new NotImplementedException();
    }

    @Override
    public Appointments fetchAppointmentsByPatient(PatientIdentifier patientIdentifier, DateFilter filter, boolean shouldIncludeDetails) {
        throw new NotImplementedException();
    }

    @Override
    public Appointment fetchAppointment(PatientIdentifier patientIdentifier, String appointmentId) {
        throw new NotImplementedException();
    }
}
