package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid;

import java.util.Collection;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.agilex.healthcare.mobilehealthplatform.datalayer.allergy.AllergyDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.ConnectionManagerFactory;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.IOvidConnectionManager;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.medsphere.ovid.domain.ov.OvidDomainException;
import com.medsphere.ovid.domain.ov.PatientItemRepository;
import com.medsphere.ovid.model.domain.patient.IsAPatientItem;
import com.medsphere.ovid.model.domain.patient.PatientAllergy;

public class AllergyDataLayerOvid implements AllergyDataLayer {
	private static final Log logger = LogFactory.getLog(AllergyDataLayerOvid.class);

	@Override
	public Allergies getPatientAllergies(String patientId) {
		Collection<IsAPatientItem> ovidAllergies = getOvidAllergies(patientId);
		Allergies allergies = new Allergies();
		for (IsAPatientItem item : ovidAllergies) {
			Allergy allergy = translateFromOvidAllergy((PatientAllergy) item, patientId);
			allergies.add(allergy);
		}

		return allergies;
	}

	private Collection<IsAPatientItem> getOvidAllergies(String patientId) {
		IOvidConnectionManager connectionManager = ConnectionManagerFactory.getInstance();
		PatientItemRepository allergyRepository = connectionManager.getAllergyRepository();

		Collection<IsAPatientItem> ovidAllergies;
		try {
			logger.info(String.format("retrieve allergies [patient=%s]", patientId));
			ovidAllergies = allergyRepository.getAllergies(patientId);
			logger.info(String.format("retrieve %s allergies [patient=%s]", ovidAllergies.size(), patientId));
		} catch (OvidDomainException e) {
			throw new RuntimeException(e);
		} finally {
			connectionManager.releaseRepositoryConnections(allergyRepository);
		}
		return ovidAllergies;
	}

	private Allergy translateFromOvidAllergy(PatientAllergy ovidAllergy, String patientId) {
		Allergy allergy = null;
		if (ovidAllergy != null) {
			allergy = new Allergy();
			allergy.setSubstance(ovidAllergy.getMessage());
			allergy.setUniqueId(ovidAllergy.getId());
			allergy.setReaction(ovidAllergy.getSigns());
			allergy.setSeverity(ovidAllergy.getSeverity());
			allergy.setPatientId(patientId);
		}
		return allergy;
	}
	
	@Override
	public Allergies fetchAllergies(String patientId, DateFilter filter) {
		Allergies allergies = getPatientAllergies(patientId);
		return DateFilterer.filterByDate(allergies, filter);
	}

	@Override
	public Allergies fetchAllergies(PatientIdentifier patientIdentifier, DateFilter filter) {
		return fetchAllergies(patientIdentifier.getUniqueId(), filter);
	}

}
