package com.agilex.healthcare.testutility;

import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.PatientDataLayerOvid;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.ConnectionManagerFactory;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.mobilehealthplatform.domain.Problem;

public class PatientTestHelper {
	public static void initializeOvidConnectionManager() {
		ConnectionManagerFactory.setConfiguration(IntegrationTestConfiguration.getOvidConfiguration());
	}

	@Deprecated
	public static Patient getTestPatient() {
		return IntegrationTestConfiguration.getTestPatient();
	}

	@Deprecated
	public static Patient getTestPatientWithNoData() {
		String searchString = "healthy,patient";
		return getPatient(searchString);
	}

	@Deprecated
	public static Patient getPatient(String searchString) {
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setSearchString(searchString);

		PatientDataLayerOvid datalayer = new PatientDataLayerOvid();
		Patients patients = datalayer.patientSearch(criteria);
		if (patients.size() > 0)
			return patients.get(0);
		else
			return null;
	}

	@Deprecated
	public static Allergy getTestAllergy() {
		return IntegrationTestConfiguration.getTestAllergy();
	}

	@Deprecated
	public static Problem getTestProblem() {
		return IntegrationTestConfiguration.getTestProblem();
	}

}
