package com.agilex.healthcare.testutility;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.OvidConfiguration;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointment;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Problem;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalSign;
import com.agilex.healthcare.mobilehealthplatform.ovid.domain.OvidImageMetadata;
import com.agilex.healthcare.mobilehealthplatform.ovid.domain.OvidPatient;

public class IntegrationTestConfiguration {

		public static final String CONFIGURATION_FILENAME = "integrationApplicationContext.xml";
		private static final String ovidConfigStr = "ovidConfiguration";
//		private static Map<String, String> properties = null;
		private static BeanFactory factory;

		static {
			factory = new ClassPathXmlApplicationContext(new String[] { CONFIGURATION_FILENAME });
//			properties = (Map<String, String>) factory.getBean("configProperties");
		}

		public static Patient getPatient(String patientKey) {
			return (Patient) factory.getBean(patientKey);
		}

		public static Patient getTestPatient() {
			return getPatient("patientTest");
		}

		public static Patient getTestInpatient() {
			return getPatient("inpatientTest");
		}
		
		public static Patient getTestPatientWithoutData() {
			return getPatient("patientHealthy");
		}
		
		public static OvidConfiguration getOvidConfiguration(){
			return factory.getBean(ovidConfigStr, OvidConfiguration.class);
		}

		public static Allergy getTestAllergy() {
			return factory.getBean("testAllergy", Allergy.class);
		}

		public static Problem getTestProblem() {
			return factory.getBean("testProblem", Problem.class);
		}

		public static Medication getInpatientMedication() {
			return factory.getBean("testInpatientMedication", Medication.class);
		}

		public static Medication getInpatientMedication2() {
			return factory.getBean("testInpatientMedication2", Medication.class);
		}		
		
		public static Medication getOutpatientMedication() {
			return factory.getBean("testOutpatientMedication", Medication.class);
		}
		
		public static Medication getTestNonVAMedication() {
			return factory.getBean("testNonVAMedication", Medication.class);
		}
		
		public static Medication getTestExpiredMedication() {
			return factory.getBean("testExpiredMedication", Medication.class);
		}
		
		
		public static Patient getTestPatientIdWithMultipleMedications() {
			return factory.getBean("testPatientIdWithMultipleMedications", Patient.class);			
		}

		public static Appointment getTestAppoitment() {
			return factory.getBean("testAppointment1", Appointment.class);
		}
		

//		public static Patient getTestPatientWithoutMiddleName() {
//			return getPatient("patientWithoutMiddleName");
//		}
//
//		public static Patient getTestPatientWithSpaceInName() {
//			return getPatient("patientWithSpaceInName");
//		}
//
//		public static String getMobileHealthServerBaseUri() {
//			return getProperty("MobileHealthPlatformServerURI");
//		}
//
//		public static AuthenticationInfo getAuthenticationInformation() {
//			AuthenticationInfo authenticationInfo = null;
//			if (NullChecker.isNotNullish(getAuthType())) {
//				authenticationInfo = new AuthenticationInfo();
//				authenticationInfo.setUsername(getUsername());
//				authenticationInfo.setPassword(getPassword());
//				authenticationInfo.setAuthtype(getAuthType());
//			}
//			return authenticationInfo;
//		}
//
//		private static String getUsername() {
//			return getProperty("username");
//		}
//
//		private static String getPassword() {
//			return getProperty("password");
//		}
//
//		private static String getAuthType() {
//			String authtype = getProperty("authtype");
//			return authtype;
//		}
//
//		private static String getProperty(String key) {
//			return properties.get(key);
//		}
//
//		public static Patient getTestPatientWithNoDate() {
//			return getPatient("patientHealthy");
//		}
//
//		public static Allergy getTestPatientAllergy() {
//			return (Allergy) factory.getBean("patientYounger.testAllergyName");
//		}
//
//		public static Patient getMedPatient() {
//			return getPatient("patientMed");
//		}
//
//		public static Medication getOutpatientMedication() {
//			return (Medication) factory.getBean("patientMed.outpatientMed");
//		}
//
		public static Patient getLabPatient() {
			return getPatient("patientLab");
		}
//
		public static LabResult getNormalLab() {
			return (LabResult) factory.getBean("patientLab.testLabNormal");
		}

		public static LabResult getNormalLabForReferenceRangeCheck() {
			return (LabResult) factory.getBean("patientLab.testLabNormal.referenceRangeCheck");
		}
		
		public static LabResult getMicroLab() {
			return (LabResult) factory.getBean("patientLab.microbiologyLab");
		}
		
//
//		public static LabResult getLabPatientTestLab2() {
//			return (LabResult) factory.getBean("patientLab.testLab2-recent");
//		}
//
//		public static LabResult getLabPatientTestLabAbnormal() {
//			return (LabResult) factory.getBean("patientLab.testLabAbnormal");
//		}
//
//		public static LabResult getLabPatientTestLabNormal() {
//			return (LabResult) factory.getBean("patientLab.testLabNormal");
//		}
//
//		public static Patient getFirst     Patient() {
//			return getPatient("patientFirst     ");
//		}
//		
//		public static HashMap<String, String> getAppointmentData(){
//			return factory.getBean("expectedAppointmentData", HashMap.class);
//		}

		public static OvidPatient getTestPatientForVitalSigns() {
			return  (OvidPatient) factory.getBean("testPatientForVitalSigns");
		}
				
		public static VitalSign getTestVitalSignTemperature() {
			return  (VitalSign) factory.getBean("testVitalSignTemperature");
		}
		
		public static VitalSign getTestVitalSignBloodPressure() {
			return  (VitalSign) factory.getBean("testVitalSignBloodPressure");
		}

		public static VitalSign getTestVitalSignPN() {
			return  (VitalSign) factory.getBean("testVitalSignPN");
		}
		
		public static OvidPatient getTestPatientForLookup() {
			return  (OvidPatient) factory.getBean("testPatientForLookup");
		}
		
		public static OvidPatient getTestPatientForLookupWithMultipleResults() {
			return  (OvidPatient) factory.getBean("testPatientForLookupWithMultipleResults");
		}

		public static OvidPatient getTestPatientForLookupContainsDOBWithYearOnly() {
			return  (OvidPatient) factory.getBean("testPatientForLookupContainsDOBWithYearOnly");
		}

		public static OvidPatient getTestPatientForLookupContainsDOBWithMonthYearOnly() {
			return  (OvidPatient) factory.getBean("testPatientForLookupContainsDOBWithMonthYearOnly");
		}
		
		public static Medication getMedicationForSig() {
			return (Medication) factory.getBean("testMedicationSig");
		}

		public static Medication getMedicationForSig2() {
			return (Medication) factory.getBean("testMedicationSig2");
		}

		public static Medication getMedicationForSig3() {
			return (Medication) factory.getBean("testMedicationSig3");
		}
		
		public static String getMedicationHistoryStringForInpatientMedication() {
			return (String) factory.getBean("medicationHistoryStringForInpatientMedication");
		}
		
		public static String getMedicationHistoryStringForOutpatientMedication() {
			return (String) factory.getBean("medicationHistoryStringForOutpatientMedication");
		}

		public static String getMedicationDetailStringForInpatientMedication() {
			return (String) factory.getBean("medicationDetailStringForInpatientMedication");
		}

		public static String getMedicationDetailStringForOutpatientMedication() {
			return (String) factory.getBean("medicationDetailStringForOutpatientMedication");
		}
		
		public static OvidImageMetadata getImageMetadata() {
			return (OvidImageMetadata) factory.getBean("imageMetadata");
		}

		public static OvidPatient getPatientForImageMetadata() {
			return (OvidPatient) factory.getBean("testPatientForImageMetadata");
		}
				
		public static String getTestSystem() {
			return (String) factory.getBean("testSystem");
		}
		
}
