package com.agilex.healthcare.mobilehealthplatform.ovid.repositories;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.ConnectionManagerFactory;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.IOvidConnectionManager;
import com.agilex.healthcare.mobilehealthplatform.ovid.VitalSignRepository;
import com.agilex.healthcare.testutility.PatientTestHelper;
import com.medsphere.ovid.domain.ov.IsAVitalSign;

public class VitalSignRepositoryTest {

	private VitalSignRepository repo;
	private IOvidConnectionManager connectionManager;

	@Before
	public void setUp(){
		PatientTestHelper.initializeOvidConnectionManager();
		connectionManager = ConnectionManagerFactory.getInstance();
		repo = connectionManager.getVitalSignRepository();
	}

	@After
	public void tearDown(){
		connectionManager.releaseRepositoryConnections(repo);
	}
	
	@Test
	public void validateGetLatestVitalSigns() throws Exception{
		Collection<IsAVitalSign> vitalSignList = repo.getMostRecentVitalSigns("1");
		for (IsAVitalSign sign : vitalSignList) {
			System.out.println(sign);
		}
	}

	//@Test
	public void validateGetVitalSigns() throws Exception{
		Calendar calendar = Calendar.getInstance();
		calendar.set(2009, 1, 1);
		Date beginDate = calendar.getTime();
		calendar.set(2011, 5, 2);
		Date endDate = calendar.getTime();
		Collection<IsAVitalSign> vitalSignList = repo.getVitalSigns("2", beginDate, endDate);
		for (IsAVitalSign sign : vitalSignList) {
			System.out.println(sign);
		}
	}

}
