package com.agilex.healthcare.mobilehealthplatform.ovid.repositories;

import static org.junit.Assert.assertTrue;

import java.util.Collection;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.ConnectionManagerFactory;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.IOvidConnectionManager;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.basic.OvidConnectionManagerBasic;
import com.agilex.healthcare.mobilehealthplatform.ovid.LabTestRepository;
import com.agilex.healthcare.mobilehealthplatform.ovid.domain.OvidLabTestCache;
import com.agilex.healthcare.testutility.PatientTestHelper;
import com.medsphere.common.cache.GenericCacheException;
import com.medsphere.fmdomain.FMLaboratoryTest;
import com.medsphere.ovid.domain.ov.OvidDomainException;
import com.medsphere.vistarpc.RPCConnection;

public class LabTestRepositoryTest {

	RPCConnection serverConnection;
	OvidConnectionManagerBasic connManager;
	LabTestRepository repo;
	

	@Before
	public void setUp() throws Exception {
		PatientTestHelper.initializeOvidConnectionManager();
		IOvidConnectionManager connectionManager = ConnectionManagerFactory.getInstance();
		repo = connectionManager.getLabTestRepository();
	}

	@After
	public void tearDown() throws Exception {
		ConnectionManagerFactory.getInstance().releaseRepositoryConnections(repo);
		repo = null;
	}

	@Test
	public void validateGetLabTestsByPatient() throws OvidDomainException, GenericCacheException {
		Collection<FMLaboratoryTest> labTests = null;
		labTests = OvidLabTestCache.getInstance().getCacheValues();
		
		for (FMLaboratoryTest labTest : labTests) {
			System.out.println(String.format("result: [name=%s][short name=%s][id=%s]", labTest.getName(), labTest.getValue("PRINT NAME"), labTest.getIEN()));
		}
		assertTrue(!labTests.isEmpty());		
	}
}
