package com.agilex.healthcare.mobilehealthplatform.ovid.repositories;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.List;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.ConnectionManagerFactory;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.IOvidConnectionManager;
import com.agilex.healthcare.mobilehealthplatform.ovid.ImageMetadataRepository;
import com.agilex.healthcare.mobilehealthplatform.ovid.domain.OvidImageMetadata;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.PatientTestHelper;
import com.medsphere.ovid.domain.ov.OvidDomainException;
import com.medsphere.vistarpc.RPCConnection;

public class ImageMetadataRepositoryTest {

	RPCConnection serverConnection;
	ImageMetadataRepository repo;

	@Before
	public void setUp() throws Exception {
		PatientTestHelper.initializeOvidConnectionManager();
		IOvidConnectionManager connectionManager = ConnectionManagerFactory.getInstance();
		repo = new ImageMetadataRepository(connectionManager.getServerConnection());
	}

	@After
	public void tearDown() throws Exception {
		// need to close connections
	}

	// @Test
	public void validateGetMetadataDetail() throws OvidDomainException {
		OvidImageMetadata expectedImage = IntegrationTestConfiguration.getImageMetadata();
		OvidImageMetadata retrievedImage = repo.getImageMetadataDetail(expectedImage.getImageId());
		assertEquals(expectedImage.getDateUploaded(), retrievedImage.getDateUploaded());
		assertEquals(expectedImage.getDescription(), retrievedImage.getDescription());
		assertEquals(expectedImage.getImageUrl(), retrievedImage.getImageUrl());
		assertEquals(expectedImage.getType(), retrievedImage.getType());
		assertEquals(expectedImage.getImageId(), retrievedImage.getImageId());
	}

	@Test
	public void validateGetMetadataForPatient() throws OvidDomainException {
		if (IntegrationTestConfiguration.getTestSystem().equals("ov")) {
			OvidImageMetadata expectedImage = IntegrationTestConfiguration.getImageMetadata();
			List<OvidImageMetadata> images = repo.getImageMetadata(IntegrationTestConfiguration
					.getPatientForImageMetadata().getId());
			boolean hasImage = false;
			assertNotNull(images);
			assertTrue(images.size() > 0);
			for (OvidImageMetadata retrievedImage : images) {
				if (retrievedImage.getImageId().equals(expectedImage.getImageId())) {
					hasImage = true;
					assertEquals(expectedImage.getDateUploaded(), retrievedImage.getDateUploaded());
					assertEquals(expectedImage.getDescription(), retrievedImage.getDescription());
					assertEquals(expectedImage.getImageUrl(), retrievedImage.getImageUrl());
					assertEquals(expectedImage.getType(), retrievedImage.getType());
					assertEquals(expectedImage.getImageId(), retrievedImage.getImageId());
				}
			}
			assertTrue(hasImage);
		}
	}
}
