package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.vital;

import static org.junit.Assert.assertTrue;

import java.util.Calendar;
import java.util.Date;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.VitalDataLayerOvid;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalSign;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalSigns;
import com.agilex.healthcare.mobilehealthplatform.ovid.domain.OvidPatient;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.PatientTestHelper;

public class VitalDataLayerTest {
	@Before
	public void setup() {
		PatientTestHelper.initializeOvidConnectionManager();
	}

	@Test
	public void validateMostRecentVitalSignsAreReturnedForTestPatient() throws Exception {
		VitalDataLayerOvid dao = new VitalDataLayerOvid();
		OvidPatient patient = IntegrationTestConfiguration.getTestPatientForVitalSigns();
		VitalSign expectedVitalSignTemperature = IntegrationTestConfiguration.getTestVitalSignTemperature();
		System.out.println(expectedVitalSignTemperature);
		VitalSign expectedVitalSignBloodPressure = IntegrationTestConfiguration.getTestVitalSignBloodPressure();
		System.out.println(expectedVitalSignBloodPressure);
		VitalSign expectedVitalSignPN = IntegrationTestConfiguration.getTestVitalSignPN();
		System.out.println(expectedVitalSignPN);
		VitalSigns vitalSigns = dao.getMostRecentVitalSigns(patient.getId());
		System.out.println("patientid=" + patient.getId());
		assertVitalSigns(vitalSigns);		
	}

	@Test
	public void validateVitalSignsByDateAreReturnedForTestPatient() throws Exception {
		VitalDataLayerOvid dao = new VitalDataLayerOvid();
		OvidPatient patient = IntegrationTestConfiguration.getTestPatientForVitalSigns();
		Calendar calendar = Calendar.getInstance();
		calendar.set(2000, 1, 1);
		Date startDate = calendar.getTime();
		calendar.set(2011, 5, 2);
		Date endDate = calendar.getTime();
		VitalSigns vitalSigns = dao.getVitalSigns(patient.getId(), startDate, endDate);
		System.out.println("patientid=" + patient.getId());
		assertVitalSigns(vitalSigns);
	}
	
	private void assertVitalSigns(VitalSigns vitalSigns) {
		assertTrue(vitalSigns.size() > 0);
		VitalSign expectedVitalSignTemperature = IntegrationTestConfiguration.getTestVitalSignTemperature();
		VitalSign expectedVitalSignBloodPressure = IntegrationTestConfiguration.getTestVitalSignBloodPressure();
		VitalSign expectedVitalSignPN = IntegrationTestConfiguration.getTestVitalSignPN();
		boolean hasMatchingTemperature = false;
		boolean hasMatchingBloodPressure = false;
		boolean hasMatchingPN = false;
		for (VitalSign vitalSign : vitalSigns) {
			if (vitalSign.getVitalId().equals(expectedVitalSignTemperature.getVitalId())) {
				hasMatchingTemperature = true;
				assertTrue(vitalSign.getValue().equals(expectedVitalSignTemperature.getValue()));
				if (vitalSign.getValueUnits() != null) {
					assertTrue(vitalSign.getValueUnits().equals(expectedVitalSignTemperature.getValueUnits()));
				} else {
					assertTrue(expectedVitalSignTemperature.getValueUnits() == null);
				}
				assertTrue(vitalSign.getVitalType().equals(expectedVitalSignTemperature.getVitalType()));
			}
			if (vitalSign.getVitalId().equals(expectedVitalSignBloodPressure.getVitalId())) {
				hasMatchingBloodPressure = true;
				assertTrue(vitalSign.getValue().equals(expectedVitalSignBloodPressure.getValue()));
				if (vitalSign.getValueUnits() != null) {
					assertTrue(vitalSign.getValueUnits().equals(expectedVitalSignBloodPressure.getValueUnits()));
				} else {
					assertTrue(expectedVitalSignBloodPressure.getValueUnits() == null);
				}
				assertTrue(vitalSign.getVitalType().equals(expectedVitalSignBloodPressure.getVitalType()));
			}
			if (vitalSign.getVitalId().equals(expectedVitalSignPN.getVitalId())) {
				hasMatchingPN = true;
				assertTrue(vitalSign.getValue().equals(expectedVitalSignPN.getValue()));
				if (vitalSign.getValueUnits() != null) {
					assertTrue(vitalSign.getValueUnits().equals(expectedVitalSignPN.getValueUnits()));
				} else {
					assertTrue(expectedVitalSignPN.getValueUnits() == null);
				}
				assertTrue(vitalSign.getVitalType().equals(expectedVitalSignPN.getVitalType()));
			}
			System.out.println("vital sign=" + vitalSign.toString());
			System.out.println("vitaltype=" + vitalSign.getVitalType());
			System.out.println("vitalvalue=" + vitalSign.getValue());
			System.out.println("vitalunits=" + vitalSign.getValueUnits());
			System.out.println("vitaldate=" + vitalSign.getMeasuredDate());
		}
		assertTrue(hasMatchingTemperature);
		assertTrue(hasMatchingBloodPressure);
		assertTrue(hasMatchingPN);
		
	}
}
