package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.scalabilitytests;

import static org.junit.Assert.assertTrue;

import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.ConnectionManagerFactory;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.IOvidConnectionManager;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.OvidConfiguration;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.basic.OvidConnectionManagerBasic;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.pooled.OvidConnectionManagerWithPooling;
import com.agilex.healthcare.testutility.PatientTestHelper;
import com.medsphere.ovid.domain.ov.PatientRepository;
import com.medsphere.vistarpc.RPCException;

@Ignore
public class OvidRepositoryManagerTest {

	private static final int number_of_runs = 50;


	@Test
	public void scalablityTestWithConnectionPooling() throws RPCException {
		PatientTestHelper.initializeOvidConnectionManager();
		OvidConfiguration configuration = ConnectionManagerFactory.getConfiguration();
		configuration.setUsePool(true);
		configuration.setInitialServerConnections(2);
		configuration.setInitialUserConnections(2);
		configuration.setMaxFreeServerConnections(10);
		configuration.setMaxFreeUserConnections(10);
		IOvidConnectionManager connectionManager = new OvidConnectionManagerWithPooling(configuration);
		runScalabilityTest(connectionManager, number_of_runs);
	}
	
	@Test
	public void scalablityTestWithoutConnectionPooling() throws RPCException {
		PatientTestHelper.initializeOvidConnectionManager();
		OvidConfiguration configuration = ConnectionManagerFactory.getConfiguration();
		configuration.setUsePool(false);
		OvidConnectionManagerBasic connectionManager = new OvidConnectionManagerBasic(configuration);
		runScalabilityTest(connectionManager, number_of_runs);
	}

	private void runScalabilityTest(IOvidConnectionManager connectionManager, int numberOfRuns) {
		final long startTime = System.nanoTime();
		final long endTime;

		for (int i = 1; i <= numberOfRuns; i++) {
			PatientRepository repo = connectionManager.getPatientRepository();
			assertTrue(repo != null);
			connectionManager.releaseRepositoryConnections(repo);
		}

		endTime = System.nanoTime();
		final long duration = (endTime - startTime)/1000000000;
		System.out.println("connection manager scalability test, time = " + duration + " seconds. [" + connectionManager.toString() + "]");
	}

}
