package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.scalabilitytests;

import static com.agilex.healthcare.testutility.AssertEx.assertEqualsIgnoreCase;
import static junit.framework.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.Collection;
import java.util.Date;

import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.ConnectionManagerFactory;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.pooled.OvidConnectionManagerWithPooling;
import com.agilex.healthcare.mobilehealthplatform.ovid.OvidPatientRepository;
import com.agilex.healthcare.mobilehealthplatform.ovid.domain.OvidPatient;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.PatientTestHelper;
import com.medsphere.ovid.domain.ov.OvidDomainException;
import com.medsphere.vistarpc.RPCConnection;

@Ignore
public class OvidConnectionTimeOutTest {

	public static final int SLEEP_TIME = 4 * 60 * 1000;
	private OvidConnectionManagerWithPooling connectionManager = null;

	@Before
	public void setUp() throws Exception {
		PatientTestHelper.initializeOvidConnectionManager();
		connectionManager = (OvidConnectionManagerWithPooling) ConnectionManagerFactory.getInstance();
	}

	@After
	public void tearDown() throws Exception {
		connectionManager.terminateAllConnections();
	}

	@Test
	public void validateTimeOutWithConnectionPool() {
		RPCConnection con1 = connectionManager.getServerConnection();
		RPCConnection con2 = connectionManager.getServerConnection();
		validateFreeConnections(0, 2);
		RPCConnection con3 = connectionManager.getServerConnection();
		validateFreeConnections(0, 3);
		connectionManager.releaseConnection(con1);
		validateFreeConnections(1, 2);
		connectionManager.releaseConnection(con2);
		validateFreeConnections(2, 1);

		try {
			Thread.sleep(SLEEP_TIME);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

		System.err.println("startTime=" + new Date().toString());
		boolean isValid = connectionManager
				.validateConnection((com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.pooled.RPCBrokerPooledConnection) con1);
		System.err.println("endTime=" + new Date().toString());
		assertTrue(isValid);
		
		System.err.println("startTime=" + new Date().toString());
		isValid = connectionManager
				.validateConnection((com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.pooled.RPCBrokerPooledConnection) con3);
		System.err.println("endTime=" + new Date().toString());
		assertTrue(isValid);
	}

	@Test
	public void validateTimeOutWithRepository() throws OvidDomainException {
		OvidPatient testPatient = IntegrationTestConfiguration.getTestPatientForLookup();
		OvidPatientRepository repo = connectionManager.getOvidPatientRepository();
		Collection<OvidPatient> patients = repo.lookupPatientsByName(testPatient.getFamilyName());
		validatePatientData(testPatient, patients.iterator().next());
		try {
			Thread.sleep(SLEEP_TIME);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		System.err.println("startTime=" + new Date().toString());
		validatePatientData(testPatient, patients.iterator().next());
		System.err.println("endTime=" + new Date().toString());
	}

	private void validatePatientData(OvidPatient expectedPatient, OvidPatient retrievedPatient) {
		assertEqualsIgnoreCase(expectedPatient.getName(), retrievedPatient.getName());
		assertEquals(expectedPatient.getDob().toString(), retrievedPatient.getDob());
	}

	private void validateFreeConnections(int expectedFreeConnections, int expectedUsedConnections) {
		assertEquals(expectedFreeConnections, connectionManager.getNumServerConnectionsFree());
		assertEquals(expectedUsedConnections, connectionManager.getNumServerConnectionsUsed());
	}

}
